/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.Reader;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.commons.lang.StringUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.fcrepo.indexer.AbsentTransformPropertyException;
import org.fcrepo.indexer.Indexer;
import org.fcrepo.indexer.NamedFieldsRetriever;
import org.fcrepo.indexer.RdfRetriever;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.utils.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexerGroup
implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexerGroup.class);
    private final String repositoryURL;
    private final Set<Indexer<Object>> indexers;
    private final DefaultHttpClient httpClient;
    private Set<String> reindexed;
    static final String IDENTIFIER_HEADER_NAME = "http://fedora.info/definitions/v4/repository#identifier";
    static final String PROPERTIES_HEADER_NAME = "http://fedora.info/definitions/v4/repository#properties";
    static final String BASE_URL_HEADER_NAME = "http://fedora.info/definitions/v4/repository#baseURL";
    static final String EVENT_TYPE_HEADER_NAME = "http://fedora.info/definitions/v4/repository#eventType";
    static final String REMOVAL_EVENT_TYPE = "http://fedora.info/definitions/v4/repository#" + EventType.valueOf((Integer)2).toString();
    private static final String REINDEX_EVENT_TYPE = "http://fedora.info/definitions/v4/repository#NODE_REINDEXED";
    public static final String INDEXER_NAMESPACE = "http://fedora.info/definitions/v4/indexing#";
    public static final Property INDEXING_TRANSFORM_PREDICATE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/indexing#hasIndexingTransformation");
    public static final Resource INDEXABLE_MIXIN = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/indexing#indexable");
    static final Resource DATASTREAM_TYPE = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/rest-api#datastream");
    private static final Reader EMPTY_CONTENT = null;

    public IndexerGroup(String repositoryURL, Set<Indexer<Object>> indexers, String fedoraUsername, String fedoraPassword) {
        this(repositoryURL, indexers, IndexerGroup.createHttpClient(repositoryURL, fedoraUsername, fedoraPassword));
    }

    protected static DefaultHttpClient createHttpClient(String repositoryURL, String fedoraUsername, String fedoraPassword) {
        PoolingClientConnectionManager connMann = new PoolingClientConnectionManager();
        connMann.setMaxTotal(Integer.MAX_VALUE);
        connMann.setDefaultMaxPerRoute(Integer.MAX_VALUE);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connMann);
        httpClient.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy());
        httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(0, false));
        if (!StringUtils.isBlank((String)fedoraUsername) && !StringUtils.isBlank((String)fedoraPassword)) {
            LOGGER.debug("Adding BASIC credentials to client for repo requests.");
            URI fedoraUri = URI.create(repositoryURL);
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(fedoraUri.getHost(), fedoraUri.getPort()), (Credentials)new UsernamePasswordCredentials(fedoraUsername, fedoraPassword));
            httpClient.setCredentialsProvider((CredentialsProvider)credsProvider);
        }
        return httpClient;
    }

    public IndexerGroup(String repositoryURL, Set<Indexer<Object>> indexers, DefaultHttpClient httpClient) {
        LOGGER.debug("Creating IndexerGroup: {}", (Object)this);
        assert (null != repositoryURL);
        this.repositoryURL = repositoryURL;
        assert (indexers.size() > 0);
        this.indexers = indexers;
        assert (null != httpClient);
        this.httpClient = httpClient;
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    public void onMessage(Message message) {
        try {
            LOGGER.debug("Received message: {}", (Object)message.getJMSMessageID());
        }
        catch (JMSException e) {
            LOGGER.error("Received unintelligible message: {}", (Throwable)e);
            Throwables.propagate((Throwable)e);
        }
        try {
            String eventType = message.getStringProperty(EVENT_TYPE_HEADER_NAME);
            String id = message.getStringProperty(IDENTIFIER_HEADER_NAME);
            String baseURL = message.getStringProperty(BASE_URL_HEADER_NAME);
            LOGGER.debug("Discovered id: {} in message.", (Object)id);
            LOGGER.debug("Discovered event type: {} in message.", (Object)eventType);
            LOGGER.debug("Discovered baseURL: {} in message.", (Object)baseURL);
            LOGGER.debug("Discovered properties: {} in message.", (Object)message.getStringProperty(PROPERTIES_HEADER_NAME));
            this.index(baseURL + id, eventType);
        }
        catch (JMSException e) {
            LOGGER.error("Error processing JMS event!", (Throwable)e);
        }
    }

    private void index(String uri, String eventType) {
        Boolean removal = REMOVAL_EVENT_TYPE.equals(eventType);
        LOGGER.debug("It is {} that this is a removal operation.", (Object)removal);
        Supplier rdfr = Suppliers.memoize((Supplier)new RdfRetriever(uri, (HttpClient)this.httpClient));
        Supplier nfr = Suppliers.memoize((Supplier)new NamedFieldsRetriever(uri, (HttpClient)this.httpClient, (Supplier<Model>)rdfr));
        Boolean indexable = false;
        if (!removal.booleanValue()) {
            Model rdf = (Model)rdfr.get();
            if (rdf.contains(ResourceFactory.createResource((String)uri), RDF.type, (RDFNode)INDEXABLE_MIXIN)) {
                LOGGER.debug("Resource: {} retrieved with indexable type.", (Object)uri);
                indexable = true;
            } else {
                LOGGER.debug("Resource: {} retrieved without indexable type.", (Object)uri);
            }
            if (rdf.contains(ResourceFactory.createResource((String)uri), RDF.type, (RDFNode)DATASTREAM_TYPE) && uri.indexOf("/fedora:system/") == -1) {
                String parent = uri.substring(0, uri.lastIndexOf("/"));
                LOGGER.info("Datastream found, also indexing parent {}", (Object)parent);
                this.index(parent, "NODE_UPDATED");
            }
        }
        for (Indexer<Object> indexer : this.indexers) {
            LOGGER.debug("Operating for indexer: {}", indexer);
            Boolean hasContent = false;
            Object content = EMPTY_CONTENT;
            if (!removal.booleanValue() && indexable.booleanValue()) {
                switch (indexer.getIndexerType()) {
                    case NAMEDFIELDS: {
                        LOGGER.debug("Retrieving named fields for: {}, (may be cached) to index to {}...", (Object)uri, indexer);
                        try {
                            content = nfr.get();
                            hasContent = true;
                        }
                        catch (AbsentTransformPropertyException e) {
                            LOGGER.error("Failed to retrieve indexable content:could not find transform property!");
                            hasContent = false;
                        }
                        break;
                    }
                    case RDF: {
                        LOGGER.debug("Retrieving RDF for: {}, (may be cached) to index to {}...", (Object)uri, indexer);
                        content = rdfr.get();
                        hasContent = true;
                        break;
                    }
                    default: {
                        hasContent = true;
                    }
                }
            }
            try {
                if (removal.booleanValue()) {
                    LOGGER.debug("Executing removal of: {} to indexer: {}...", (Object)uri, indexer);
                    indexer.remove(uri);
                    continue;
                }
                if (hasContent.booleanValue()) {
                    LOGGER.debug("Executing update of: {} to indexer: {}...", (Object)uri, indexer);
                    indexer.update(uri, content);
                    continue;
                }
                if (!indexable.booleanValue()) continue;
                LOGGER.error("Received update for: {} but was unable to retrieve content for update to indexer: {}!", (Object)uri, indexer);
            }
            catch (Exception e) {
                LOGGER.error("Error indexing {}: {}!", (Object)uri, (Object)e);
            }
        }
    }

    public void reindex() {
        this.reindexed = new HashSet<String>();
        this.reindexURI(this.getRepositoryURL(), true);
    }

    public void reindex(String uri, boolean recursive) {
        this.reindexed = new HashSet<String>();
        this.reindexURI(uri, recursive);
    }

    private void reindexURI(String uri, boolean recursive) {
        LOGGER.debug("Reindexing {}, recursive: {}", (Object)uri, (Object)recursive);
        if (!this.reindexed.contains(uri)) {
            this.index(uri, REINDEX_EVENT_TYPE);
        }
        this.reindexed.add(uri);
        if (recursive) {
            Supplier rdfr = Suppliers.memoize((Supplier)new RdfRetriever(uri, (HttpClient)this.httpClient));
            Model model = (Model)rdfr.get();
            NodeIterator children = model.listObjectsOfProperty(RdfLexicon.HAS_CHILD);
            while (children.hasNext()) {
                String child = children.nextNode().asResource().getURI();
                if (this.reindexed.contains(child)) continue;
                this.reindexURI(child, true);
            }
        }
    }
}

