/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfRetriever
implements Supplier<Model> {
    private static final String RDF_SERIALIZATION = "text/rdf+n3";
    private final String identifier;
    private final HttpClient httpClient;
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfRetriever.class);

    public RdfRetriever(String identifier, HttpClient client) {
        this.identifier = identifier;
        this.httpClient = client;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Model get() {
        HttpGet request = new HttpGet(this.identifier);
        request.addHeader("Accept", RDF_SERIALIZATION);
        LOGGER.debug("Retrieving RDF content from: {}...", (Object)request.getURI());
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) throw new HttpException(response.getStatusLine().toString());
            try (InputStreamReader r = new InputStreamReader(response.getEntity().getContent(), "UTF8");){
                Model model = ModelFactory.createDefaultModel().read((Reader)r, "", "N3");
                return model;
            }
        }
        catch (IOException | HttpException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

