/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer.webapp;

import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fcrepo.indexer.IndexerGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class FedoraIndexer
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexerGroup.class);
    private IndexerGroup indexer;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        this.indexer = (IndexerGroup)ctx.getBean(sc.getInitParameter("beanName"));
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String recurParam = request.getParameter("recursive");
        boolean recursive = recurParam == null || recurParam.equals("true");
        String path = request.getPathInfo();
        this.indexer.reindex(this.indexer.getRepositoryURL() + path, recursive);
        try {
            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();
            out.println("Reindexing started");
        }
        catch (Exception ex) {
            LOGGER.warn("Error sending output");
        }
    }
}

