/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.jms.headers;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.fcrepo.jms.observer.JMSEventMessageFactory;
import org.fcrepo.kernel.observer.FedoraEvent;
import org.fcrepo.kernel.utils.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageFactory
implements JMSEventMessageFactory {
    public static final String TIMESTAMP_HEADER_NAME = "http://fedora.info/definitions/v4/repository#timestamp";
    public static final String IDENTIFIER_HEADER_NAME = "http://fedora.info/definitions/v4/repository#identifier";
    public static final String EVENT_TYPE_HEADER_NAME = "http://fedora.info/definitions/v4/repository#eventType";
    public static final String BASE_URL_HEADER_NAME = "http://fedora.info/definitions/v4/repository#baseURL";
    public static final String PROPERTIES_HEADER_NAME = "http://fedora.info/definitions/v4/repository#properties";
    private String baseURL;
    private static final Logger log = LoggerFactory.getLogger(DefaultMessageFactory.class);

    private void setBaseURL(FedoraEvent event) {
        try {
            JsonObject json = new JsonParser().parse(event.getUserData()).getAsJsonObject();
            this.baseURL = json.get("baseURL").getAsString();
            log.debug("MessageFactory baseURL: {}", (Object)this.baseURL);
        }
        catch (Exception ex) {
            log.warn("Error setting baseURL", (Throwable)ex);
        }
    }

    @Override
    public Message getMessage(FedoraEvent jcrEvent, Session jmsSession) throws RepositoryException, IOException, JMSException {
        if (this.baseURL == null) {
            this.setBaseURL(jcrEvent);
        }
        Message message = jmsSession.createMessage();
        message.setLongProperty(TIMESTAMP_HEADER_NAME, jcrEvent.getDate());
        message.setStringProperty(IDENTIFIER_HEADER_NAME, jcrEvent.getPath());
        message.setStringProperty(EVENT_TYPE_HEADER_NAME, DefaultMessageFactory.getEventURIs(jcrEvent.getTypes()));
        message.setStringProperty(BASE_URL_HEADER_NAME, this.baseURL);
        message.setStringProperty(PROPERTIES_HEADER_NAME, Joiner.on((char)',').join((Iterable)jcrEvent.getProperties()));
        log.trace("getMessage() returning: {}", (Object)message);
        return message;
    }

    private static String getEventURIs(Set<Integer> types) {
        String uris = Joiner.on((char)',').join(Iterables.transform(types, (Function)new Function<Integer, String>(){

            public String apply(Integer type) {
                return "http://fedora.info/definitions/v4/repository#" + EventType.valueOf((Integer)type);
            }
        }));
        log.debug("Constructed event type URIs: {}", (Object)uris);
        return uris;
    }
}

