/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.jms;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.fcrepo.jms.JMSEventMessageFactory;
import org.fcrepo.kernel.api.observer.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJMSPublisher {
    @Inject
    private EventBus eventBus;
    @Inject
    private ActiveMQConnectionFactory connectionFactory;
    @Inject
    private JMSEventMessageFactory eventFactory;
    private Connection connection;
    protected Session jmsSession;
    private MessageProducer producer;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJMSPublisher.class);

    protected abstract Destination createDestination() throws JMSException;

    @Subscribe
    @AllowConcurrentEvents
    public void publishJCREvent(Event event) throws JMSException {
        LOGGER.debug("Received an event from the internal bus. {}", (Object)event);
        Message tm = this.eventFactory.getMessage(event, this.jmsSession);
        LOGGER.trace("Transformed the event to a JMS message.");
        this.producer.send(tm);
        LOGGER.debug("Put event: {} onto JMS.", (Object)tm.getJMSMessageID());
    }

    @PostConstruct
    public void acquireConnections() throws JMSException {
        LOGGER.debug("Initializing: {}", (Object)this.getClass().getCanonicalName());
        this.connection = this.connectionFactory.createConnection();
        this.connection.start();
        this.jmsSession = this.connection.createSession(false, 1);
        this.producer = this.jmsSession.createProducer(this.createDestination());
        this.eventBus.register((Object)this);
    }

    @PreDestroy
    public void releaseConnections() throws JMSException {
        LOGGER.debug("Tearing down: {}", (Object)this.getClass().getCanonicalName());
        this.producer.close();
        this.jmsSession.close();
        this.connection.close();
        this.eventBus.unregister((Object)this);
    }
}

