/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.jms;

import java.util.Set;
import java.util.stream.Collectors;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.fcrepo.event.serialization.JsonLDSerializer;
import org.fcrepo.jms.JMSEventMessageFactory;
import org.fcrepo.kernel.api.observer.Event;
import org.fcrepo.kernel.api.observer.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageFactory
implements JMSEventMessageFactory {
    private static final String JMS_NAMESPACE = "org.fcrepo.jms.";
    public static final String TIMESTAMP_HEADER_NAME = "org.fcrepo.jms.timestamp";
    public static final String IDENTIFIER_HEADER_NAME = "org.fcrepo.jms.identifier";
    public static final String EVENT_TYPE_HEADER_NAME = "org.fcrepo.jms.eventType";
    public static final String BASE_URL_HEADER_NAME = "org.fcrepo.jms.baseURL";
    public static final String RESOURCE_TYPE_HEADER_NAME = "org.fcrepo.jms.resourceType";
    public static final String USER_HEADER_NAME = "org.fcrepo.jms.user";
    public static final String USER_AGENT_HEADER_NAME = "org.fcrepo.jms.userAgent";
    public static final String EVENT_ID_HEADER_NAME = "org.fcrepo.jms.eventID";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMessageFactory.class);

    @Override
    public Message getMessage(Event event, Session jmsSession) throws JMSException {
        JsonLDSerializer serializer = new JsonLDSerializer();
        String body = serializer.serialize(event);
        TextMessage message = jmsSession.createTextMessage(body);
        message.setLongProperty(TIMESTAMP_HEADER_NAME, event.getDate().toEpochMilli());
        message.setStringProperty(BASE_URL_HEADER_NAME, event.getBaseUrl());
        if (event.getUserAgent() != null) {
            message.setStringProperty(USER_AGENT_HEADER_NAME, event.getUserAgent());
        }
        message.setStringProperty(IDENTIFIER_HEADER_NAME, event.getPath());
        message.setStringProperty(EVENT_TYPE_HEADER_NAME, DefaultMessageFactory.getEventURIs(event.getTypes()));
        message.setStringProperty(USER_HEADER_NAME, event.getUserID());
        message.setStringProperty(RESOURCE_TYPE_HEADER_NAME, String.join((CharSequence)",", event.getResourceTypes()));
        message.setStringProperty(EVENT_ID_HEADER_NAME, event.getEventID());
        LOGGER.trace("getMessage() returning: {}", (Object)message);
        return message;
    }

    private static String getEventURIs(Set<EventType> types) {
        String uris = types.stream().map(EventType::getType).collect(Collectors.joining(","));
        LOGGER.debug("Constructed event type URIs: {}", (Object)uris);
        return uris;
    }
}

