/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils.iterators;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;

public class DifferencingIterator<E>
extends AbstractIterator<E> {
    Set<? extends E> notCommon;
    private Set<E> common;
    private Iterator<E> source;

    public DifferencingIterator(Set<? extends E> original, Iterator<E> source) {
        this.notCommon = Sets.newHashSet(original);
        this.common = Sets.newHashSet();
        this.source = source;
    }

    protected E computeNext() {
        if (this.source.hasNext()) {
            E next = this.source.next();
            while (this.common.contains(next) || this.notCommon.contains(next)) {
                if (this.notCommon.remove(next)) {
                    this.common.add(next);
                }
                if (!this.source.hasNext()) {
                    return (E)this.endOfData();
                }
                next = this.source.next();
            }
            return next;
        }
        return (E)this.endOfData();
    }

    public Set<E> common() {
        return this.source.hasNext() ? null : this.common;
    }

    public Set<? extends E> notCommon() {
        return this.source.hasNext() ? null : this.notCommon;
    }
}

