/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.observer;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.services.functions.HierarchicalIdentifierSupplier;
import org.fcrepo.kernel.api.services.functions.UniqueValueSupplier;
import org.fcrepo.kernel.api.utils.EventType;

public class FedoraEvent {
    private Event e;
    private final String eventID;
    private Set<Integer> eventTypes = new HashSet<Integer>();
    private Set<String> eventProperties = new HashSet<String>();
    private static final UniqueValueSupplier pidMinter = new DefaultPathMinter();

    public FedoraEvent(Event e) {
        Preconditions.checkArgument((e != null ? 1 : 0) != 0, (Object)"null cannot support a FedoraEvent!");
        this.eventID = (String)pidMinter.get();
        this.e = e;
    }

    public FedoraEvent(FedoraEvent e) {
        Preconditions.checkArgument((e != null ? 1 : 0) != 0, (Object)"null cannot support a FedoraEvent!");
        this.eventID = e.getEventID();
        this.e = e.e;
    }

    public Set<Integer> getTypes() {
        return this.eventTypes != null ? Sets.union(Collections.singleton(this.e.getType()), this.eventTypes) : Collections.singleton(this.e.getType());
    }

    public FedoraEvent addType(Integer type) {
        this.eventTypes.add(type);
        return this;
    }

    public Set<String> getProperties() {
        return this.eventProperties;
    }

    public FedoraEvent addProperty(String property) {
        this.eventProperties.add(property);
        return this;
    }

    public String getPath() {
        return FedoraEvent.getPath(this.e);
    }

    public static String getPath(Event e) {
        try {
            if (e.getType() == 4 || e.getType() == 16 || e.getType() == 8) {
                return e.getPath().substring(0, e.getPath().lastIndexOf("/"));
            }
            return e.getPath();
        }
        catch (RepositoryException e1) {
            throw new RepositoryRuntimeException("Error getting event path!", e1);
        }
    }

    public String getUserID() {
        return this.e.getUserID();
    }

    public Map<Object, Object> getInfo() {
        try {
            return this.e.getInfo();
        }
        catch (RepositoryException e1) {
            throw new RepositoryRuntimeException("Error getting event info!", e1);
        }
    }

    public String getUserData() {
        try {
            return this.e.getUserData();
        }
        catch (RepositoryException e1) {
            throw new RepositoryRuntimeException("Error getting event userData!", e1);
        }
    }

    public long getDate() {
        try {
            return this.e.getDate();
        }
        catch (RepositoryException e1) {
            throw new RepositoryRuntimeException("Error getting event date!", e1);
        }
    }

    public String getEventID() {
        return this.eventID;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Event types:", (Object)String.join((CharSequence)",", this.getTypes().stream().map(x -> EventType.valueOf(x).getName()).collect(Collectors.toList()))).add("Event properties:", (Object)String.join((CharSequence)",", this.eventProperties)).add("Path:", (Object)this.getPath()).add("Date: ", this.getDate()).add("Info:", this.getInfo()).toString();
    }

    private static class DefaultPathMinter
    implements HierarchicalIdentifierSupplier {
        private DefaultPathMinter() {
        }
    }
}

