/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.services.functions;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.fcrepo.kernel.api.services.functions.JcrPropertyFunctions;
import org.fcrepo.kernel.api.utils.UncheckedFunction;
import org.fcrepo.kernel.api.utils.UncheckedPredicate;

public class AnyTypesPredicate
implements UncheckedPredicate<Node> {
    protected final Collection<String> nodeTypes;

    public AnyTypesPredicate(String ... types) {
        this.nodeTypes = Arrays.asList(types);
    }

    @Override
    public boolean testThrows(Node input) throws RepositoryException {
        Objects.requireNonNull(input, "null node has no types!");
        if (JcrPropertyFunctions.isFrozen.test(input) && input.hasProperty("jcr:frozenMixinTypes")) {
            Property frozenTypesProperty = input.getProperty("jcr:frozenMixinTypes");
            ImmutableList values = ImmutableList.copyOf(JcrPropertyFunctions.property2values.apply(frozenTypesProperty));
            if (values.stream().map(UncheckedFunction.uncheck(Value::getString)).anyMatch(this.nodeTypes::contains)) {
                return true;
            }
        }
        return this.nodeTypes.stream().anyMatch(UncheckedPredicate.uncheck(arg_0 -> ((Node)input).isNodeType(arg_0)));
    }
}

