/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.utils;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum EventType {
    NODE_ADDED(1, "node added"),
    NODE_REMOVED(2, "node removed"),
    PROPERTY_ADDED(4, "property added"),
    PROPERTY_REMOVED(8, "property removed"),
    PROPERTY_CHANGED(16, "property changed"),
    NODE_MOVED(32, "node moved"),
    PERSIST(64, "persist");

    private static final Map<Integer, EventType> translation;
    private final Integer jcrEventType;
    private final String eventName;

    private EventType(Integer eventType, String eventName) {
        this.jcrEventType = eventType;
        this.eventName = eventName;
    }

    public String getName() {
        return this.eventName;
    }

    public static EventType valueOf(Integer i) {
        return (EventType)((Object)Functions.forMap(translation).apply((Object)i));
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (EventType eventType : EventType.values()) {
            b.put((Object)eventType.jcrEventType, (Object)eventType);
        }
        translation = b.build();
    }
}

