/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.rdf;

import java.util.Comparator;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.utils.WrappingStream;

public class DefaultRdfStream
extends WrappingStream<Triple>
implements RdfStream {
    protected final Node node;

    public DefaultRdfStream(Node node) {
        this(node, Stream.empty());
    }

    public DefaultRdfStream(Node node, Stream<Triple> stream) {
        Objects.requireNonNull(node);
        this.node = node;
        this.stream = stream;
    }

    public static RdfStream fromModel(Node node, Model model) {
        return new DefaultRdfStream(node, StreamSupport.stream(Spliterators.spliteratorUnknownSize(model.listStatements(), 1024), false).map(FrontsTriple::asTriple));
    }

    protected void concat(Stream<Triple> stream) {
        this.stream = Stream.concat(this.stream, stream);
    }

    @Override
    public Node topic() {
        return this.node;
    }

    public RdfStream distinct() {
        return new DefaultRdfStream(this.topic(), this.stream.distinct());
    }

    public RdfStream filter(Predicate<? super Triple> predicate) {
        return new DefaultRdfStream(this.topic(), this.stream.filter(predicate));
    }

    public RdfStream limit(long maxSize) {
        return new DefaultRdfStream(this.topic(), this.stream.limit(maxSize));
    }

    public RdfStream peek(Consumer<? super Triple> action) {
        return new DefaultRdfStream(this.topic(), this.stream.peek(action));
    }

    public RdfStream skip(long n) {
        return new DefaultRdfStream(this.topic(), this.stream.skip(n));
    }

    public RdfStream sorted() {
        return new DefaultRdfStream(this.topic(), this.stream.sorted());
    }

    public RdfStream sorted(Comparator<? super Triple> comparator) {
        return new DefaultRdfStream(this.topic(), this.stream.sorted(comparator));
    }

    @Override
    public RdfStream onClose(Runnable closeHandler) {
        return new DefaultRdfStream(this.topic(), (Stream)this.stream.onClose(closeHandler));
    }

    @Override
    public RdfStream parallel() {
        return new DefaultRdfStream(this.topic(), (Stream)this.stream.parallel());
    }

    @Override
    public RdfStream sequential() {
        return new DefaultRdfStream(this.topic(), (Stream)this.stream.sequential());
    }

    @Override
    public RdfStream unordered() {
        return new DefaultRdfStream(this.topic(), (Stream)this.stream.unordered());
    }
}

