/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.utils;

import com.google.common.base.Throwables;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.function.Predicate;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContentDigest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentDigest.class);
    public static final String DEFAULT_ALGORITHM = DIGEST_ALGORITHM.SHA1.algorithm;

    private ContentDigest() {
    }

    public static URI asURI(String algorithm, String value) {
        try {
            String scheme = DIGEST_ALGORITHM.getScheme(algorithm);
            return new URI(scheme, value, null);
        }
        catch (URISyntaxException unlikelyException) {
            LOGGER.warn("Exception creating checksum URI: {}", (Throwable)unlikelyException);
            throw Throwables.propagate((Throwable)unlikelyException);
        }
    }

    public static URI asURI(String algorithm, byte[] data) {
        return ContentDigest.asURI(algorithm, ContentDigest.asString(data));
    }

    public static String getAlgorithm(URI digestUri) {
        if (digestUri == null) {
            return DEFAULT_ALGORITHM;
        }
        return DIGEST_ALGORITHM.fromScheme((String)new StringBuilder().append((String)digestUri.getScheme()).append((String)":").append((String)digestUri.getSchemeSpecificPart().split((String)":", (int)2)[0]).toString()).algorithm;
    }

    private static String asString(byte[] data) {
        return Hex.encodeHexString((byte[])data);
    }

    public static URI missingChecksum() {
        return ContentDigest.asURI(DIGEST_ALGORITHM.SHA1.algorithm, DIGEST_ALGORITHM.SHA1.scheme);
    }

    public static enum DIGEST_ALGORITHM {
        SHA1("SHA-1", "urn:sha1"),
        SHA256("SHA-256", "urn:sha256"),
        MD5("MD5", "urn:md5"),
        MISSING("NONE", "missing");

        public final String algorithm;
        private final String scheme;

        private DIGEST_ALGORITHM(String alg, String scheme) {
            this.algorithm = alg;
            this.scheme = scheme;
        }

        public static String getScheme(String alg) {
            return Arrays.stream(DIGEST_ALGORITHM.values()).filter((Predicate<DIGEST_ALGORITHM>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getScheme$5(java.lang.String org.fcrepo.kernel.api.utils.ContentDigest$DIGEST_ALGORITHM ), (Lorg/fcrepo/kernel/api/utils/ContentDigest$DIGEST_ALGORITHM;)Z)((String)alg)).findFirst().orElse((DIGEST_ALGORITHM)DIGEST_ALGORITHM.MISSING).scheme;
        }

        public static DIGEST_ALGORITHM fromScheme(String argScheme) {
            return Arrays.stream(DIGEST_ALGORITHM.values()).filter(value -> value.scheme.equalsIgnoreCase(argScheme)).findFirst().orElse(MISSING);
        }

        public static boolean isSupportedAlgorithm(String alg) {
            return !DIGEST_ALGORITHM.getScheme(alg).equals(DIGEST_ALGORITHM.MISSING.scheme);
        }

        private static /* synthetic */ boolean lambda$getScheme$5(String string, DIGEST_ALGORITHM value) {
            return value.algorithm.equalsIgnoreCase(string) || value.algorithm.replace("-", "").equalsIgnoreCase(string);
        }
    }
}

