/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.utils;

import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.graph.GraphFactory;

public class GraphDifferencer {
    private Graph notCommon;
    private Graph common;
    private Stream.Builder<Triple> source = Stream.builder();

    public GraphDifferencer(Model replacement, Stream<Triple> original) {
        this(replacement.getGraph(), original);
    }

    public GraphDifferencer(Graph replacement, Stream<Triple> original) {
        this.notCommon = replacement;
        this.common = GraphFactory.createDefaultGraph();
        original.forEach(x -> {
            GraphDifferencer graphDifferencer = this;
            synchronized (graphDifferencer) {
                if (this.notCommon.contains(x)) {
                    this.notCommon.remove(x.getSubject(), x.getPredicate(), x.getObject());
                    this.common.add(x);
                } else if (!this.common.contains(x)) {
                    this.source.accept((Triple)x);
                }
            }
        });
    }

    public Stream<Triple> difference() {
        return this.source.build();
    }

    public Stream<Triple> common() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.common.find(Node.ANY, Node.ANY, Node.ANY), 1024), false);
    }

    public Stream<Triple> notCommon() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.notCommon.find(Node.ANY, Node.ANY, Node.ANY), 1024), false);
    }
}

