/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.models;

import java.net.URI;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.TripleCategory;
import org.fcrepo.kernel.api.exception.AccessDeniedException;
import org.fcrepo.kernel.api.exception.MalformedRdfException;
import org.fcrepo.kernel.api.identifiers.IdentifierConverter;

public interface FedoraResource {
    public String getPath();

    default public Stream<FedoraResource> getChildren() {
        return this.getChildren(false);
    }

    public Stream<FedoraResource> getChildren(Boolean var1);

    public FedoraResource getContainer();

    public FedoraResource getOriginalResource();

    public FedoraResource getTimeMap();

    public Instant getMementoDatetime();

    public boolean isMemento();

    public boolean isAcl();

    public FedoraResource findMementoByDatetime(Instant var1);

    public FedoraResource getAcl();

    public FedoraResource findOrCreateAcl();

    public FedoraResource getChild(String var1);

    public boolean hasProperty(String var1);

    public void delete();

    public Instant getCreatedDate();

    public Instant getLastModifiedDate();

    public boolean hasType(String var1);

    public List<URI> getTypes();

    public void addType(String var1);

    public void updateProperties(IdentifierConverter<Resource, FedoraResource> var1, String var2, RdfStream var3) throws MalformedRdfException, AccessDeniedException;

    public RdfStream getTriples(IdentifierConverter<Resource, FedoraResource> var1, TripleCategory var2);

    public RdfStream getTriples(IdentifierConverter<Resource, FedoraResource> var1, Set<? extends TripleCategory> var2);

    public Boolean isNew();

    public void replaceProperties(IdentifierConverter<Resource, FedoraResource> var1, Model var2, RdfStream var3) throws MalformedRdfException;

    public String getEtagValue();

    public boolean isOriginalResource();

    public FedoraResource getDescription();

    public FedoraResource getDescribedResource();
}

