/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.utils;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AutoReloadingConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoReloadingConfiguration.class);
    protected String configPath;
    private boolean monitorForChanges;
    private Thread monitorThread;
    private boolean monitorRunning;

    public void init() throws IOException {
        if (StringUtils.isEmpty((CharSequence)this.configPath)) {
            return;
        }
        this.loadConfiguration();
        if (this.monitorForChanges) {
            this.monitorForChanges();
        }
    }

    public void shutdown() {
        if (this.monitorThread != null) {
            this.monitorThread.interrupt();
        }
    }

    protected abstract void loadConfiguration() throws IOException;

    private void monitorForChanges() {
        Path path;
        if (this.monitorRunning) {
            return;
        }
        try {
            path = Paths.get(this.configPath, new String[0]);
        }
        catch (Exception e) {
            LOGGER.warn("Cannot monitor configuration {}, disabling monitoring; {}", (Object)this.configPath, (Object)e.getMessage());
            return;
        }
        if (!path.toFile().exists()) {
            LOGGER.debug("Configuration {} does not exist, disabling monitoring", (Object)this.configPath);
            return;
        }
        Path directoryPath = path.getParent();
        try {
            final WatchService watchService = FileSystems.getDefault().newWatchService();
            directoryPath.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            this.monitorThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        block11: while (true) {
                            WatchKey key;
                            try {
                                key = watchService.take();
                            }
                            catch (InterruptedException e) {
                                LOGGER.debug("Interrupted the configuration monitor thread.");
                                break;
                            }
                            Iterator<WatchEvent<?>> iterator = key.pollEvents().iterator();
                            while (true) {
                                boolean valid;
                                if (!iterator.hasNext()) continue block11;
                                WatchEvent<?> event = iterator.next();
                                WatchEvent.Kind<?> kind = event.kind();
                                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                                Path changed = (Path)event.context();
                                if (changed.equals(path.getFileName())) {
                                    LOGGER.info("Configuration {} has been updated, reloading.", (Object)path);
                                    try {
                                        AutoReloadingConfiguration.this.loadConfiguration();
                                    }
                                    catch (IOException e) {
                                        LOGGER.error("Failed to reload configuration {}", (Object)AutoReloadingConfiguration.this.configPath, (Object)e);
                                    }
                                }
                                if (!(valid = key.reset())) break;
                            }
                            LOGGER.debug("Monitor of {} is no longer valid", (Object)path);
                        }
                    }
                    finally {
                        try {
                            watchService.close();
                        }
                        catch (IOException e) {
                            LOGGER.error("Failed to stop configuration monitor", (Throwable)e);
                        }
                    }
                    AutoReloadingConfiguration.this.monitorRunning = false;
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Failed to start configuration monitor", (Throwable)e);
        }
        this.monitorThread.start();
        this.monitorRunning = true;
    }

    public void setConfigPath(String configPath) {
        if (configPath != null && configPath.startsWith("classpath:")) {
            String relativePath = configPath.substring(10);
            this.configPath = this.getClass().getResource(relativePath).getPath();
        } else {
            this.configPath = configPath;
        }
    }

    public void setMonitorForChanges(boolean monitorForChanges) {
        this.monitorForChanges = monitorForChanges;
    }
}

