/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.utils;

import java.util.Calendar;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.exception.MalformedRdfException;

public class RelaxedPropertiesHelper {
    public static Calendar getCreatedDate(Iterable<Statement> statements) {
        return RelaxedPropertiesHelper.extractSingleCalendarValue(statements, RdfLexicon.CREATED_DATE);
    }

    public static String getCreatedBy(Iterable<Statement> statements) {
        return RelaxedPropertiesHelper.extractSingleStringValue(statements, RdfLexicon.CREATED_BY);
    }

    public static Calendar getModifiedDate(Iterable<Statement> statements) {
        return RelaxedPropertiesHelper.extractSingleCalendarValue(statements, RdfLexicon.LAST_MODIFIED_DATE);
    }

    public static String getModifiedBy(Iterable<Statement> statements) {
        return RelaxedPropertiesHelper.extractSingleStringValue(statements, RdfLexicon.LAST_MODIFIED_BY);
    }

    private static String extractSingleStringValue(Iterable<Statement> statements, Property predicate) {
        String username = null;
        for (Statement added : statements) {
            if (!added.getPredicate().equals(predicate)) continue;
            if (username == null) {
                username = added.getObject().asLiteral().getString();
                continue;
            }
            throw new MalformedRdfException(predicate + " may only appear once!");
        }
        return username;
    }

    private static Calendar extractSingleCalendarValue(Iterable<Statement> statements, Property predicate) {
        Calendar cal = null;
        for (Statement added : statements) {
            if (!added.getPredicate().equals(predicate)) continue;
            if (cal == null) {
                cal = RelaxedPropertiesHelper.parseExpectedXsdDateTimeValue(added.getObject());
                continue;
            }
            throw new MalformedRdfException(predicate + " may only appear once!");
        }
        return cal;
    }

    private static Calendar parseExpectedXsdDateTimeValue(RDFNode node) {
        Object value = node.asLiteral().getValue();
        if (value instanceof XSDDateTime) {
            return ((XSDDateTime)value).asCalendar();
        }
        throw new IllegalArgumentException("Expected an xsd:dateTime!");
    }

    private RelaxedPropertiesHelper() {
    }
}

