/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.utils;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamUtils.class);
    private static Boolean enableParallel = false;
    private static final String FCREPO_STEAMING_PARALLEL_KEY = "fcrepo.streaming.parallel";

    public static <T> Stream<T> iteratorToStream(Iterator<T> iterator) {
        return StreamUtils.iteratorToStream(iterator, enableParallel);
    }

    public static <T> Stream<T> iteratorToStream(Iterator<T> iterator, Boolean parallel) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1024), parallel);
    }

    private StreamUtils() {
    }

    static {
        String enableParallelVal = System.getProperty(FCREPO_STEAMING_PARALLEL_KEY, "false").trim().toLowerCase();
        if (!enableParallelVal.equals("true") && !enableParallelVal.equals("false")) {
            LOGGER.warn("The {} parameter contains an invalid value of {}:  allowed values are 'true' and 'false'. The default value of {} remain unchanged.", new Object[]{FCREPO_STEAMING_PARALLEL_KEY, enableParallelVal, enableParallel});
        } else {
            enableParallel = Boolean.valueOf(enableParallelVal);
        }
    }
}

