/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.models;

import java.net.URI;
import java.time.Instant;
import java.util.List;
import java.util.stream.Stream;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.exception.PathNotFoundException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.TimeMap;

public interface FedoraResource {
    public String getId();

    public FedoraId getFedoraId();

    public FedoraResource getParent() throws PathNotFoundException;

    @Deprecated
    public String getPath();

    default public Stream<FedoraResource> getChildren() {
        return this.getChildren(false);
    }

    public Stream<FedoraResource> getChildren(Boolean var1);

    public FedoraResource getContainer();

    public FedoraResource getOriginalResource();

    public TimeMap getTimeMap();

    public Instant getMementoDatetime();

    public boolean isMemento();

    public boolean isAcl();

    public FedoraResource findMementoByDatetime(Instant var1);

    public FedoraResource getAcl();

    public boolean hasProperty(String var1);

    public Instant getCreatedDate();

    public String getCreatedBy();

    public Instant getLastModifiedDate();

    public String getLastModifiedBy();

    public boolean hasType(String var1);

    public List<URI> getUserTypes();

    public List<URI> getSystemTypes(boolean var1);

    public List<URI> getTypes();

    public RdfStream getTriples();

    @Deprecated
    public Boolean isNew();

    public String getEtagValue();

    public String getStateToken();

    public boolean isOriginalResource();

    public FedoraResource getDescription();

    public FedoraResource getDescribedResource();

    public String getInteractionModel();
}

