/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.utils;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.StringConcatFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContentDigest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentDigest.class);
    private static final String DEFAULT_DIGEST_ALGORITHM_PROPERTY = "fcrepo.persistence.defaultDigestAlgorithm";
    public static final DIGEST_ALGORITHM DEFAULT_DIGEST_ALGORITHM = DIGEST_ALGORITHM.fromAlgorithm(System.getProperty("fcrepo.persistence.defaultDigestAlgorithm", DIGEST_ALGORITHM.SHA512.algorithm));
    public static final String DEFAULT_ALGORITHM;

    private ContentDigest() {
    }

    public static URI asURI(String algorithm, String value) {
        try {
            String scheme = DIGEST_ALGORITHM.getScheme(algorithm);
            return new URI(scheme, value, null);
        }
        catch (URISyntaxException unlikelyException) {
            LOGGER.warn("Exception creating checksum URI: alg={}; value={}", (Object)algorithm, (Object)value);
            throw new RepositoryRuntimeException(unlikelyException.getMessage(), unlikelyException);
        }
    }

    public static URI asURI(String algorithm, byte[] data) {
        return ContentDigest.asURI(algorithm, ContentDigest.asString(data));
    }

    public static String getAlgorithm(URI digestUri) {
        if (digestUri == null) {
            return DEFAULT_ALGORITHM;
        }
        return DIGEST_ALGORITHM.fromScheme((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001:\u0001"}, (String)digestUri.getScheme(), (String)digestUri.getSchemeSpecificPart().split((String)":", (int)2)[0]))).algorithm;
    }

    private static String asString(byte[] data) {
        return Hex.encodeHexString((byte[])data);
    }

    public static URI missingChecksum() {
        return ContentDigest.asURI(DIGEST_ALGORITHM.SHA1.algorithm, DIGEST_ALGORITHM.SHA1.scheme);
    }

    static {
        if (DIGEST_ALGORITHM.MISSING.equals((Object)DEFAULT_DIGEST_ALGORITHM)) {
            throw new IllegalArgumentException("Invalid fcrepo.persistence.defaultDigestAlgorithm property configured: " + System.getProperty(DEFAULT_DIGEST_ALGORITHM_PROPERTY));
        }
        DEFAULT_ALGORITHM = DIGEST_ALGORITHM.SHA1.algorithm;
    }

    public static enum DIGEST_ALGORITHM {
        SHA1("SHA", "urn:sha1", "sha-1", "sha1"),
        SHA256("SHA-256", "urn:sha-256", "sha256"),
        SHA512("SHA-512", "urn:sha-512", "sha512"),
        SHA512256("SHA-512/256", "urn:sha-512/256", "sha512/256"),
        MD5("MD5", "urn:md5", new String[0]),
        MISSING("NONE", "missing", new String[0]);

        public final String algorithm;
        private final String scheme;
        private final Set<String> aliases;

        private DIGEST_ALGORITHM(String alg, String scheme, String ... aliases) {
            this.algorithm = alg;
            this.scheme = scheme;
            this.aliases = Arrays.stream((String[])ArrayUtils.add((Object[])aliases, (Object)this.algorithm)).map(String::toLowerCase).collect(Collectors.toSet());
        }

        public static String getScheme(String alg) {
            return Arrays.stream(DIGEST_ALGORITHM.values()).filter((Predicate<DIGEST_ALGORITHM>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getScheme$0(java.lang.String org.fcrepo.kernel.api.utils.ContentDigest$DIGEST_ALGORITHM ), (Lorg/fcrepo/kernel/api/utils/ContentDigest$DIGEST_ALGORITHM;)Z)((String)alg)).findFirst().orElse((DIGEST_ALGORITHM)DIGEST_ALGORITHM.MISSING).scheme;
        }

        public static DIGEST_ALGORITHM fromScheme(String argScheme) {
            return Arrays.stream(DIGEST_ALGORITHM.values()).filter(value -> value.scheme.equalsIgnoreCase(argScheme)).findFirst().orElse(MISSING);
        }

        public static DIGEST_ALGORITHM fromAlgorithm(String alg) {
            String seek = alg.toLowerCase();
            return Arrays.stream(DIGEST_ALGORITHM.values()).filter(value -> value.aliases.contains(seek)).findFirst().orElse(MISSING);
        }

        public static boolean isSupportedAlgorithm(String alg) {
            return !DIGEST_ALGORITHM.getScheme(alg).equals(DIGEST_ALGORITHM.MISSING.scheme);
        }

        public Set<String> getAliases() {
            return this.aliases;
        }

        private static /* synthetic */ boolean lambda$getScheme$0(String alg, DIGEST_ALGORITHM value) {
            return value.algorithm.equalsIgnoreCase(alg) || value.algorithm.replace("-", "").equalsIgnoreCase(alg);
        }
    }
}

