/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;

public final class RdfLexicon {
    public static final String REPOSITORY_NAMESPACE = "http://fedora.info/definitions/v4/repository#";
    public static final String REPOSITORY_WEBAC_NAMESPACE = "http://fedora.info/definitions/v4/webac#";
    public static final String FCREPO_API_NAMESPACE = "http://fedora.info/definitions/fcrepo#";
    public static final String ACTIVITY_STREAMS_NAMESPACE = "https://www.w3.org/ns/activitystreams#";
    public static final String EBUCORE_NAMESPACE = "http://www.ebu.ch/metadata/ontologies/ebucore/ebucore#";
    public static final String OA_NAMESPACE = "http://www.w3.org/ns/oa#";
    public static final String PROV_NAMESPACE = "http://www.w3.org/ns/prov#";
    public static final String PREMIS_NAMESPACE = "http://www.loc.gov/premis/rdf/v1#";
    public static final String MEMENTO_NAMESPACE = "http://mementoweb.org/ns#";
    public static final String RDF_NAMESPACE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String WEBAC_NAMESPACE_VALUE = "http://www.w3.org/ns/auth/acl#";
    public static final String LDP_NAMESPACE = "http://www.w3.org/ns/ldp#";
    public static final Predicate<String> isManagedNamespace = p -> p.equals(REPOSITORY_NAMESPACE) || p.equals(LDP_NAMESPACE) || p.equals(MEMENTO_NAMESPACE);
    public static final Predicate<Triple> restrictedType = s -> s.getPredicate().equals((Object)RDF.type.asNode()) && s.getObject().isURI() && isManagedNamespace.test(s.getObject().getNameSpace());
    public static final Resource PREMIS_FIXITY = ResourceFactory.createResource((String)"http://www.loc.gov/premis/rdf/v1#Fixity");
    public static final Resource PREMIS_EVENT_OUTCOME_DETAIL = ResourceFactory.createResource((String)"http://www.loc.gov/premis/rdf/v1#EventOutcomeDetail");
    public static final Property HAS_MESSAGE_DIGEST = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasMessageDigest");
    public static final Property HAS_SIZE = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasSize");
    public static final Property HAS_FIXITY_RESULT = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasFixity");
    private static final Set<Property> fixityProperties = ImmutableSet.of((Object)HAS_FIXITY_RESULT, (Object)HAS_MESSAGE_DIGEST);
    public static final Property HAS_FIXITY_STATE = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasEventOutcome");
    public static final Property WRITABLE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#writable");
    public static final String FEDORA_NON_RDF_SOURCE_DESCRIPTION_URI = "http://fedora.info/definitions/v4/repository#NonRdfSourceDescription";
    public static final Property CREATED_DATE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#created");
    public static final Property CREATED_BY = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#createdBy");
    public static final Property LAST_MODIFIED_DATE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#lastModified");
    public static final Property LAST_MODIFIED_BY = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#lastModifiedBy");
    public static final Resource FEDORA_CONTAINER = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/repository#Container");
    public static final Resource FEDORA_BINARY = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/repository#Binary");
    public static final Resource FEDORA_RESOURCE = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/repository#Resource");
    public static final Resource FEDORA_PAIR_TREE = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/repository#Pairtree");
    public static final Resource ARCHIVAL_GROUP = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/repository#ArchivalGroup");
    public static final Property PAGE = ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#Page");
    public static final Resource CONTAINER = ResourceFactory.createResource((String)"http://www.w3.org/ns/ldp#Container");
    public static final Resource BASIC_CONTAINER = ResourceFactory.createResource((String)"http://www.w3.org/ns/ldp#BasicContainer");
    public static final Resource DIRECT_CONTAINER = ResourceFactory.createResource((String)"http://www.w3.org/ns/ldp#DirectContainer");
    public static final Resource INDIRECT_CONTAINER = ResourceFactory.createResource((String)"http://www.w3.org/ns/ldp#IndirectContainer");
    public static final Property MEMBERSHIP_RESOURCE = ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#membershipResource");
    public static final Property HAS_MEMBER_RELATION = ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#hasMemberRelation");
    public static final Property INSERTED_CONTENT_RELATION = ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#insertedContentRelation");
    public static final Property IS_MEMBER_OF_RELATION = ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#isMemberOfRelation");
    public static final Property CONTAINS = ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#contains");
    public static final Property LDP_MEMBER = ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#member");
    public static final Resource RESOURCE = ResourceFactory.createResource((String)"http://www.w3.org/ns/ldp#Resource");
    public static final Resource RDF_SOURCE = ResourceFactory.createResource((String)"http://www.w3.org/ns/ldp#RDFSource");
    public static final Resource NON_RDF_SOURCE = ResourceFactory.createResource((String)"http://www.w3.org/ns/ldp#NonRDFSource");
    public static final Property CONSTRAINED_BY = ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#constrainedBy");
    public static final Property MEMBER_SUBJECT = ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#MemberSubject");
    private static final Set<Property> ldpManagedProperties = ImmutableSet.of((Object)CONTAINS);
    public static final Property HAS_TRANSACTION_SERVICE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#hasTransactionProvider");
    public static final Resource REPOSITORY_ROOT = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/repository#RepositoryRoot");
    public static final Property HAS_FIXITY_SERVICE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#hasFixityService");
    public static final Property HAS_MIME_TYPE = ResourceFactory.createProperty((String)"http://www.ebu.ch/metadata/ontologies/ebucore/ebucore#hasMimeType");
    public static final Property HAS_ORIGINAL_NAME = ResourceFactory.createProperty((String)"http://www.ebu.ch/metadata/ontologies/ebucore/ebucore#filename");
    public static final Property EXTERNAL_CONTENT = ResourceFactory.createProperty((String)"http://fedora.info/definitions/fcrepo#ExternalContent");
    public static final Property INBOUND_REFERENCES = ResourceFactory.createProperty((String)"http://fedora.info/definitions/fcrepo#PreferInboundReferences");
    public static final Property PREFER_SERVER_MANAGED = ResourceFactory.createProperty((String)"http://fedora.info/definitions/fcrepo#ServerManaged");
    public static final Property PREFER_MINIMAL_CONTAINER = ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#PreferMinimalContainer");
    public static final Property PREFER_CONTAINMENT = ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#PreferContainment");
    public static final Property PREFER_MEMBERSHIP = ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#PreferMembership");
    public static final Property EMBED_CONTAINED = ResourceFactory.createProperty((String)"http://www.w3.org/ns/oa#PreferContainedDescriptions");
    public static final String WEBAC_ACCESS_CONTROL_VALUE = "http://www.w3.org/ns/auth/acl#accessControl";
    public static final String WEBAC_ACCESS_TO = "http://www.w3.org/ns/auth/acl#accessTo";
    public static final String WEBAC_ACCESS_TO_CLASS = "http://www.w3.org/ns/auth/acl#accessToClass";
    public static final Property WEBAC_ACCESS_TO_PROPERTY = ResourceFactory.createProperty((String)"http://www.w3.org/ns/auth/acl#accessTo");
    public static final String FEDORA_WEBAC_ACL_URI = "http://fedora.info/definitions/v4/webac#Acl";
    private static final Set<Property> serverManagedProperties;
    private static final Predicate<Property> hasFedoraNamespace;
    private static Predicate<Property> hasMementoNamespace;
    private static final Set<Property> serverManagedRelaxableProperties;
    public static final Predicate<Property> isManagedPredicate;
    public static final Predicate<Property> isRelaxablePredicate;
    public static final String VERSIONING_TIMEMAP_TYPE = "http://mementoweb.org/ns#TimeMap";
    public static final Resource VERSIONING_TIMEMAP;
    public static final String VERSIONING_TIMEGATE_TYPE = "http://mementoweb.org/ns#TimeGate";
    public static final String MEMENTO_TYPE = "http://mementoweb.org/ns#Memento";
    public static final Resource VERSIONED_RESOURCE;
    public static final Property MEMENTO_ORIGINAL_RESOURCE;
    public static final Set<Resource> INTERACTION_MODEL_RESOURCES;
    public static final Set<String> INTERACTION_MODELS_FULL;
    public static final Resource DEFAULT_INTERACTION_MODEL;

    private RdfLexicon() {
    }

    static {
        ImmutableSet.Builder b = ImmutableSet.builder();
        b.addAll(fixityProperties).addAll(ldpManagedProperties);
        serverManagedProperties = b.build();
        hasFedoraNamespace = p -> !p.isAnon() && p.getNameSpace().startsWith(REPOSITORY_NAMESPACE);
        hasMementoNamespace = p -> !p.isAnon() && p.getNameSpace().startsWith(MEMENTO_NAMESPACE);
        serverManagedRelaxableProperties = Set.of(CREATED_DATE, CREATED_BY, LAST_MODIFIED_DATE, LAST_MODIFIED_BY);
        isManagedPredicate = hasFedoraNamespace.or(hasMementoNamespace).or(serverManagedProperties::contains);
        isRelaxablePredicate = serverManagedRelaxableProperties::contains;
        VERSIONING_TIMEMAP = ResourceFactory.createResource((String)VERSIONING_TIMEMAP_TYPE);
        VERSIONED_RESOURCE = ResourceFactory.createResource((String)"http://mementoweb.org/ns#OriginalResource");
        MEMENTO_ORIGINAL_RESOURCE = ResourceFactory.createProperty((String)"http://mementoweb.org/ns#original");
        INTERACTION_MODEL_RESOURCES = ImmutableSet.of((Object)BASIC_CONTAINER, (Object)INDIRECT_CONTAINER, (Object)DIRECT_CONTAINER, (Object)NON_RDF_SOURCE);
        INTERACTION_MODELS_FULL = INTERACTION_MODEL_RESOURCES.stream().map(Resource::getURI).collect(Collectors.toSet());
        DEFAULT_INTERACTION_MODEL = BASIC_CONTAINER;
    }
}

