/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.utils;

import java.util.Calendar;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.exception.MalformedRdfException;
import org.fcrepo.kernel.api.exception.RelaxableServerManagedPropertyException;
import org.fcrepo.kernel.api.exception.ServerManagedPropertyException;
import org.fcrepo.kernel.api.exception.ServerManagedTypeException;

public class RelaxedPropertiesHelper {
    public static Calendar getCreatedDate(Resource resource) {
        Iterable<Statement> iter = RelaxedPropertiesHelper.getIterable(resource, RdfLexicon.CREATED_DATE);
        return RelaxedPropertiesHelper.extractSingleCalendarValue(iter, RdfLexicon.CREATED_DATE);
    }

    public static String getCreatedBy(Resource resource) {
        Iterable<Statement> iter = RelaxedPropertiesHelper.getIterable(resource, RdfLexicon.CREATED_BY);
        return RelaxedPropertiesHelper.extractSingleStringValue(iter, RdfLexicon.CREATED_BY);
    }

    public static Calendar getModifiedDate(Resource resource) {
        Iterable<Statement> iter = RelaxedPropertiesHelper.getIterable(resource, RdfLexicon.LAST_MODIFIED_DATE);
        return RelaxedPropertiesHelper.extractSingleCalendarValue(iter, RdfLexicon.LAST_MODIFIED_DATE);
    }

    public static String getModifiedBy(Resource resource) {
        Iterable<Statement> iter = RelaxedPropertiesHelper.getIterable(resource, RdfLexicon.LAST_MODIFIED_BY);
        return RelaxedPropertiesHelper.extractSingleStringValue(iter, RdfLexicon.LAST_MODIFIED_BY);
    }

    private static String extractSingleStringValue(Iterable<Statement> statements, Property predicate) {
        String textValue = null;
        for (Statement added : statements) {
            if (textValue == null) {
                textValue = added.getObject().asLiteral().getString();
                continue;
            }
            throw new MalformedRdfException(predicate + " may only appear once!");
        }
        return textValue;
    }

    private static Calendar extractSingleCalendarValue(Iterable<Statement> statements, Property predicate) {
        Calendar cal = null;
        for (Statement added : statements) {
            if (cal == null) {
                try {
                    cal = RelaxedPropertiesHelper.parseExpectedXsdDateTimeValue(added.getObject());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new MalformedRdfException("Expected a xsd:datetime for " + predicate, e);
                }
            }
            throw new MalformedRdfException(predicate + " may only appear once!");
        }
        return cal;
    }

    private static Calendar parseExpectedXsdDateTimeValue(RDFNode node) {
        Object value = node.asLiteral().getValue();
        if (value instanceof XSDDateTime) {
            return ((XSDDateTime)value).asCalendar();
        }
        throw new IllegalArgumentException("Expected an xsd:dateTime!");
    }

    private static Iterable<Statement> getIterable(Resource resource, Property predicate) {
        StmtIterator iterator = resource.listProperties(predicate);
        return () -> iterator;
    }

    public static void checkTripleForDisallowed(Triple triple) {
        if (triple.getPredicate().equals((Object)RDF.Init.type().asNode()) && !triple.getObject().isVariable() && !triple.getObject().isURI()) {
            throw new MalformedRdfException(String.format("Invalid rdf:type: %s", triple.getObject()));
        }
        if (RdfLexicon.restrictedType.test(triple)) {
            throw new ServerManagedTypeException(String.format("The server managed type (%s) cannot be modified by the client.", triple.getObject()));
        }
        if (RdfLexicon.isManagedPredicate.test(ResourceFactory.createProperty((String)triple.getPredicate().getURI()))) {
            String message = String.format("The server managed predicate (%s) cannot be modified by the client.", triple.getPredicate());
            if (RdfLexicon.isRelaxablePredicate.test(ResourceFactory.createProperty((String)triple.getPredicate().getURI()))) {
                throw new RelaxableServerManagedPropertyException(message);
            }
            throw new ServerManagedPropertyException(message);
        }
    }

    private RelaxedPropertiesHelper() {
    }
}

