/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.exception;

import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.models.FedoraResource;

public class TombstoneException
extends RepositoryRuntimeException {
    private static final long serialVersionUID = 1L;
    private final String uri;
    private static DateTimeFormatter isoFormatter = DateTimeFormatter.ISO_INSTANT.withZone(ZoneOffset.UTC);

    public TombstoneException(FedoraResource resource) {
        this(resource, null);
    }

    public TombstoneException(FedoraResource resource, String tombstoneUri) {
        super("Discovered tombstone resource at " + resource.getFedoraId().getFullIdPath() + (String)(Objects.nonNull(resource.getLastModifiedDate()) ? ", departed at: " + isoFormatter.format(resource.getLastModifiedDate()) : ""));
        this.uri = tombstoneUri;
    }

    public String getURI() {
        return this.uri;
    }
}

