/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.services.functions;

import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.IntStream;
import org.fcrepo.kernel.api.services.functions.UniqueValueSupplier;
import org.springframework.stereotype.Component;

@Component
public class ConfigurableHierarchicalSupplier
implements UniqueValueSupplier {
    private static final int DEFAULT_LENGTH = 0;
    private static final int DEFAULT_COUNT = 0;
    private final int length;
    private final int count;

    public ConfigurableHierarchicalSupplier(int desiredLength, int desiredCount) {
        this.length = desiredLength;
        this.count = desiredCount;
    }

    public ConfigurableHierarchicalSupplier() {
        this.length = 0;
        this.count = 0;
    }

    @Override
    public String get() {
        String id;
        String s = UUID.randomUUID().toString();
        if (this.count > 0 && this.length > 0) {
            StringJoiner joiner = new StringJoiner("/", "", "/" + s);
            IntStream.rangeClosed(0, this.count - 1).forEach(x -> joiner.add(s.substring(x * this.length, (x + 1) * this.length)));
            id = joiner.toString();
        } else {
            id = s;
        }
        return id;
    }
}

