/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.utils;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;

public class SubjectMappingUtil {
    private SubjectMappingUtil() {
    }

    public static Triple mapSubject(Triple t, String resourceUri, String destinationUri) {
        Node destinationNode = NodeFactory.createURI((String)destinationUri);
        return SubjectMappingUtil.mapSubject(t, resourceUri, destinationNode);
    }

    public static Triple mapSubject(Triple t, String resourceUri, Node destinationNode) {
        Node subject;
        Node tripleSubj = t.getSubject();
        String tripleSubjUri = tripleSubj.getURI();
        if (tripleSubjUri.equals(resourceUri)) {
            subject = destinationNode;
        } else if (tripleSubjUri.startsWith(resourceUri)) {
            String suffix = tripleSubjUri.substring(resourceUri.length());
            subject = NodeFactory.createURI((String)(destinationNode.getURI() + suffix));
        } else {
            subject = t.getSubject();
        }
        return new Triple(subject, t.getPredicate(), t.getObject());
    }
}

