/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api;

import java.time.Duration;
import java.time.Instant;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.identifiers.FedoraId;

public class ReadOnlyTransaction
implements Transaction {
    public static final ReadOnlyTransaction INSTANCE = new ReadOnlyTransaction();
    public static final String READ_ONLY_TX_ID = "read-only";

    private ReadOnlyTransaction() {
    }

    @Override
    public void commit() {
    }

    @Override
    public void commitIfShortLived() {
    }

    @Override
    public boolean isCommitted() {
        return false;
    }

    @Override
    public void rollback() {
    }

    @Override
    public void fail() {
    }

    @Override
    public boolean isRolledBack() {
        return false;
    }

    @Override
    public boolean isOpenLongRunning() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void ensureCommitting() {
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String getId() {
        return READ_ONLY_TX_ID;
    }

    @Override
    public boolean isShortLived() {
        return true;
    }

    @Override
    public void setShortLived(boolean shortLived) {
    }

    @Override
    public void expire() {
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public Instant updateExpiry(Duration amountToAdd) {
        return Instant.now().plus(amountToAdd);
    }

    @Override
    public Instant getExpires() {
        return Instant.now().plus(Duration.ofMinutes(1L));
    }

    @Override
    public void refresh() {
    }

    @Override
    public void lockResource(FedoraId resourceId) {
    }

    @Override
    public void releaseResourceLocksIfShortLived() {
    }

    @Override
    public void doInTx(Runnable runnable) {
        runnable.run();
    }

    @Override
    public void setBaseUri(String baseUri) {
    }

    @Override
    public void setUserAgent(String userAgent) {
    }

    @Override
    public void suppressEvents() {
    }
}

