/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.services.functions;

import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.fcrepo.config.FedoraPropsConfig;
import org.fcrepo.kernel.api.services.functions.UniqueValueSupplier;
import org.springframework.stereotype.Component;

@Component
public class ConfigurableHierarchicalSupplier
implements UniqueValueSupplier {
    @Inject
    protected FedoraPropsConfig fedoraPropsConfig;

    @Override
    public String get() {
        String id;
        String s = UUID.randomUUID().toString();
        int length = this.fedoraPropsConfig.getFcrepoPidMinterLength();
        int count = this.fedoraPropsConfig.getFcrepoPidMinterCount();
        if (count > 0 && length > 0) {
            StringJoiner joiner = new StringJoiner("/", "", "/" + s);
            IntStream.rangeClosed(0, count - 1).forEach(x -> joiner.add(s.substring(x * length, (x + 1) * length)));
            id = joiner.toString();
        } else {
            id = s;
        }
        return id;
    }
}

