/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.exception;

import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;

public class ConcurrentUpdateException
extends RepositoryRuntimeException {
    private static final String LOG_MESSAGE = "Cannot update %s because it is being updated by another transaction (%s).";
    private static final String HTTP_MESSAGE = "Cannot update %s because it is being updated by another transaction";
    private final String resource;
    private final String existingTx;
    private final String conflictingTx;

    public ConcurrentUpdateException(String resource, String conflictingTx, String existingTx) {
        super(String.format(LOG_MESSAGE, resource, existingTx));
        this.resource = resource;
        this.conflictingTx = conflictingTx;
        this.existingTx = existingTx;
    }

    public String getResponseMessage() {
        return String.format(HTTP_MESSAGE, this.resource);
    }

    public String getExistingTransactionId() {
        return this.existingTx;
    }

    public String getConflictingTransactionId() {
        return this.conflictingTx;
    }
}

