/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.exception;

import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.models.FedoraResource;

public class TombstoneException
extends RepositoryRuntimeException {
    private static final long serialVersionUID = 1L;
    private final String tombstoneUri;
    private final String timemapUri;
    private final FedoraResource fedoraResource;
    private static DateTimeFormatter isoFormatter = DateTimeFormatter.ISO_INSTANT.withZone(ZoneOffset.UTC);

    public TombstoneException(FedoraResource resource) {
        this(resource, null, null);
    }

    public TombstoneException(FedoraResource resource, String tombstoneUri, String timemapUri) {
        super("Discovered tombstone resource at " + resource.getFedoraId().getFullIdPath() + (String)(Objects.nonNull(resource.getLastModifiedDate()) ? ", departed at: " + isoFormatter.format(resource.getLastModifiedDate()) : ""));
        this.tombstoneUri = tombstoneUri;
        this.timemapUri = timemapUri;
        this.fedoraResource = resource;
    }

    public String getTombstoneURI() {
        return this.tombstoneUri;
    }

    public String getTimemapUri() {
        return this.timemapUri;
    }

    public FedoraResource getFedoraResource() {
        return this.fedoraResource;
    }
}

