/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.identifiers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.escape.Escaper;
import com.google.common.net.PercentEscaper;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.fcrepo.kernel.api.exception.InvalidMementoPathException;
import org.fcrepo.kernel.api.exception.InvalidResourceIdentifierException;
import org.fcrepo.kernel.api.services.VersionService;

public class FedoraId {
    private static final Set<String> FORBIDDEN_ID_PART_STRINGS = Set.of("fcr-root", ".fcrepo", "fcr-container.nt");
    private static final Set<String> FORBIDDEN_ID_PART_SUFFIXES = Set.of("~fcr-desc", "~fcr-acl", "~fcr-desc.nt", "~fcr-acl.nt");
    private final String fullId;
    private final String baseId;
    private final String fullPath;
    private final String encodedFullId;
    private final String describedId;
    private String hashUri;
    private boolean isRepositoryRoot = false;
    private boolean isNonRdfSourceDescription = false;
    private boolean isAcl = false;
    private boolean isMemento = false;
    private boolean isTimemap = false;
    private boolean isTombstone = false;
    private Instant mementoDatetime;
    private String mementoDatetimeStr;
    private static final Set<Pattern> extensions = Set.of("fcr:tombstone", "fcr:metadata", "fcr:acl", "fcr:versions").stream().map(Pattern::compile).collect(Collectors.toSet());
    private static final Escaper fedoraIdEscaper = new PercentEscaper("-._~!$'()*,;&=@:+/?#", false);

    private FedoraId(String fullId) {
        this.fullId = FedoraId.ensurePrefix(fullId).replaceAll("/+$", "");
        this.fullPath = this.fullId.substring("info:fedora".length());
        this.checkForInvalidPath();
        this.baseId = this.processIdentifier();
        this.enforceStorageLayoutNamingConstraints();
        this.encodedFullId = fedoraIdEscaper.escape(this.fullId);
        this.describedId = this.fullId.replace("/fcr:metadata", "");
    }

    @JsonCreator
    public static FedoraId create(String ... additions) {
        return new FedoraId(FedoraId.idBuilder(additions));
    }

    public static FedoraId getRepositoryRootId() {
        return new FedoraId(null);
    }

    public boolean isRepositoryRoot() {
        return this.isRepositoryRoot;
    }

    public boolean isMemento() {
        return this.isMemento;
    }

    public boolean isAcl() {
        return this.isAcl;
    }

    public boolean isTimemap() {
        return this.isTimemap;
    }

    public boolean isDescription() {
        return this.isNonRdfSourceDescription;
    }

    public boolean isTombstone() {
        return this.isTombstone;
    }

    public boolean isHashUri() {
        return this.hashUri != null;
    }

    public String getHashUri() {
        return this.hashUri;
    }

    public String getResourceId() {
        if (this.isNonRdfSourceDescription) {
            return this.baseId + "/fcr:metadata";
        }
        if (this.isAcl) {
            return this.baseId + "/fcr:acl";
        }
        return this.baseId;
    }

    public FedoraId asResourceId() {
        return FedoraId.create(this.getResourceId());
    }

    public String getBaseId() {
        return this.baseId;
    }

    public FedoraId asBaseId() {
        return FedoraId.create(this.getBaseId());
    }

    public String getFullId() {
        return this.fullId;
    }

    public String getFullIdPath() {
        return this.fullPath;
    }

    public String getEncodedFullId() {
        return this.encodedFullId;
    }

    public Instant getMementoInstant() {
        return this.mementoDatetime;
    }

    public String getMementoString() {
        return this.mementoDatetimeStr;
    }

    public FedoraId resolve(String child) {
        if (StringUtils.isBlank((CharSequence)child)) {
            throw new IllegalArgumentException("Child cannot be blank");
        }
        return FedoraId.create(this.baseId, child);
    }

    public FedoraId asAcl() {
        if (this.isAcl()) {
            return this;
        }
        return FedoraId.create(this.getBaseId(), "fcr:acl");
    }

    public FedoraId asDescription() {
        if (this.isDescription()) {
            return this;
        }
        if (this.isTimemap()) {
            return FedoraId.create(this.getBaseId(), "fcr:metadata", "fcr:versions");
        }
        if (this.isMemento()) {
            return FedoraId.create(this.getBaseId(), "fcr:metadata", "fcr:versions", this.appendHashIfPresent(this.getMementoString()));
        }
        return FedoraId.create(this.getBaseId(), this.appendHashIfPresent("fcr:metadata"));
    }

    public String getFullDescribedId() {
        return this.describedId;
    }

    public FedoraId asTombstone() {
        if (this.isTombstone()) {
            return this;
        }
        return FedoraId.create(this.getBaseId(), "fcr:tombstone");
    }

    public FedoraId asTimemap() {
        if (this.isTimemap()) {
            return this;
        }
        if (this.isDescription()) {
            return FedoraId.create(this.getBaseId(), "fcr:metadata", "fcr:versions");
        }
        return FedoraId.create(this.getBaseId(), "fcr:versions");
    }

    public FedoraId asMemento(Instant mementoInstant) {
        return this.asMemento(VersionService.MEMENTO_LABEL_FORMATTER.format(mementoInstant));
    }

    public FedoraId asMemento(String mementoString) {
        if (this.isMemento()) {
            return this;
        }
        if (this.isDescription()) {
            return FedoraId.create(this.getBaseId(), "fcr:metadata", "fcr:versions", this.appendHashIfPresent(mementoString));
        }
        if (this.isAcl() || this.isTombstone() || this.isTimemap()) {
            return FedoraId.create(this.getBaseId(), "fcr:versions", mementoString);
        }
        return FedoraId.create(this.getBaseId(), "fcr:versions", this.appendHashIfPresent(mementoString));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FedoraId)) {
            return false;
        }
        FedoraId testObj = (FedoraId)obj;
        return Objects.equals(testObj.getFullId(), this.getFullId());
    }

    public int hashCode() {
        return this.getFullId().hashCode();
    }

    @JsonValue
    public String toString() {
        return this.getFullId();
    }

    private static String idBuilder(String ... parts) {
        if (parts != null && parts.length > 0) {
            return Arrays.stream(parts).filter(Objects::nonNull).map(s -> s.startsWith("/") ? s.substring(1) : s).map(s -> s.endsWith("/") ? s.substring(0, s.length() - 1) : s).collect(Collectors.joining("/"));
        }
        return "";
    }

    private static String ensurePrefix(String id) {
        if (id == null) {
            return "info:fedora";
        }
        return id.startsWith("info:fedora") ? id : "info:fedora/" + id;
    }

    private String processIdentifier() {
        if (this.fullId.contains("//")) {
            throw new InvalidResourceIdentifierException(String.format("Path contains empty element! %s", this.fullPath));
        }
        String processID = this.fullId;
        if (processID.equals("info:fedora")) {
            this.isRepositoryRoot = true;
            return this.fullId;
        }
        if (processID.contains("#")) {
            String[] hashSplits = StringUtils.splitPreserveAllTokens((String)processID, (String)"#");
            if (hashSplits.length > 2) {
                throw new InvalidResourceIdentifierException(String.format("Path <%s> is invalid. It may not contain more than one #", this.fullPath));
            }
            this.hashUri = hashSplits[1];
            processID = hashSplits[0];
        }
        if (processID.contains("fcr:tombstone")) {
            processID = this.removePart(processID, "fcr:tombstone");
            this.isTombstone = true;
        }
        if (processID.contains("fcr:acl")) {
            processID = this.removePart(processID, "fcr:acl");
            this.isAcl = true;
        }
        if (processID.contains("fcr:versions")) {
            String[] versionSplits = this.split(processID, "fcr:versions");
            if (versionSplits.length > 2) {
                throw new InvalidResourceIdentifierException(String.format("Path <%s> is invalid. May not contain multiple %s parts.", this.fullPath, "fcr:versions"));
            }
            if (versionSplits.length == 2 && versionSplits[1].isEmpty()) {
                this.isTimemap = true;
            } else {
                String afterVersion = versionSplits[1];
                if (afterVersion.matches("/\\d{14}")) {
                    this.isMemento = true;
                    this.mementoDatetimeStr = afterVersion.substring(1);
                    try {
                        this.mementoDatetime = Instant.from(VersionService.MEMENTO_LABEL_FORMATTER.parse(this.mementoDatetimeStr));
                    }
                    catch (DateTimeParseException e) {
                        throw new InvalidMementoPathException(String.format("Invalid request for memento at %s", this.fullPath));
                    }
                } else if (afterVersion.equals("/")) {
                    this.isTimemap = true;
                } else {
                    throw new InvalidMementoPathException(String.format("Invalid request for memento at %s", this.fullPath));
                }
            }
            processID = versionSplits[0];
        }
        if (processID.contains("fcr:metadata")) {
            processID = this.removePart(processID, "fcr:metadata");
            this.isNonRdfSourceDescription = true;
        }
        if (processID.endsWith("/")) {
            processID = processID.replaceAll("/+$", "");
        }
        return processID;
    }

    private String removePart(String original, String part) {
        String[] split = this.split(original, part);
        if (split.length > 2 || split.length == 2 && !split[1].isEmpty()) {
            throw new InvalidResourceIdentifierException("Path is invalid:" + this.fullPath);
        }
        return split[0];
    }

    private String[] split(String original, String part) {
        return StringUtils.splitByWholeSeparatorPreserveAllTokens((String)original, (String)("/" + part));
    }

    private void checkForInvalidPath() {
        if ((this.fullId.contains("fcr:acl") || this.fullId.contains("fcr:tombstone")) && (this.fullId.contains("fcr:metadata") || this.fullId.contains("fcr:versions")) || this.fullId.contains("fcr:tombstone") && this.fullId.contains("fcr:acl")) {
            throw new InvalidResourceIdentifierException(String.format("Path is invalid: %s", this.fullPath));
        }
        for (Pattern extension : extensions) {
            if (extension.matcher(this.fullId).results().count() <= 1L) continue;
            throw new InvalidResourceIdentifierException(String.format("Path is invalid: %s", this.fullPath));
        }
    }

    private void enforceStorageLayoutNamingConstraints() {
        String finalPart = StringUtils.substringAfterLast((String)this.baseId, (String)"/");
        if (FORBIDDEN_ID_PART_STRINGS.contains(finalPart)) {
            throw new InvalidResourceIdentifierException(String.format("Invalid resource ID. IDs may not contain the string '%s'.", finalPart));
        }
        FORBIDDEN_ID_PART_SUFFIXES.forEach(suffix -> {
            if (finalPart.endsWith((String)suffix) && !finalPart.equals(suffix)) {
                throw new InvalidResourceIdentifierException(String.format("Invalid resource ID. IDs may not end with '%s'.", suffix));
            }
        });
    }

    private String appendHashIfPresent(String original) {
        if (this.isHashUri()) {
            return original + "#" + this.getHashUri();
        }
        return original;
    }
}

