/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.api.utils;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.codec.binary.Hex;
import org.fcrepo.config.DigestAlgorithm;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContentDigest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentDigest.class);

    private ContentDigest() {
    }

    public static URI asURI(String algorithm, String value) {
        try {
            String scheme = DigestAlgorithm.getScheme((String)algorithm);
            return new URI(scheme, value, null);
        }
        catch (URISyntaxException unlikelyException) {
            LOGGER.warn("Exception creating checksum URI: alg={}; value={}", (Object)algorithm, (Object)value);
            throw new RepositoryRuntimeException(unlikelyException.getMessage(), unlikelyException);
        }
    }

    public static URI asURI(String algorithm, byte[] data) {
        return ContentDigest.asURI(algorithm, ContentDigest.asString(data));
    }

    public static String getAlgorithm(URI digestUri) {
        return DigestAlgorithm.fromScheme((String)(digestUri.getScheme() + ":" + digestUri.getSchemeSpecificPart().split(":", 2)[0])).getAlgorithm();
    }

    private static String asString(byte[] data) {
        return Hex.encodeHexString((byte[])data);
    }
}

