/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel.impl.services;

import javax.inject.Inject;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.integration.kernel.impl.AbstractIT;
import org.fcrepo.kernel.Transaction;
import org.fcrepo.kernel.impl.TxAwareSession;
import org.fcrepo.kernel.services.NodeService;
import org.fcrepo.kernel.services.ObjectService;
import org.fcrepo.kernel.services.TransactionService;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/repo.xml"})
public class TransactionServiceImplIT
extends AbstractIT {
    @Inject
    private Repository repository;
    @Inject
    NodeService nodeService;
    @Inject
    ObjectService objectService;
    @Inject
    TransactionService transactionService;

    @Test
    public void testGetTransaction() throws RepositoryException {
        Session session = this.repository.login();
        Transaction t1 = this.transactionService.beginTransaction(session, "fedoraAdmin");
        Assert.assertNotNull((Object)t1);
        Assert.assertTrue((boolean)this.transactionService.exists(t1.getId()));
        Transaction t2 = this.transactionService.getTransaction(session);
        Assert.assertNotNull((Object)t2);
        Assert.assertEquals((Object)t1.getId(), (Object)t2.getId());
    }

    @Test
    public void testGetTransactionUser() throws RepositoryException {
        Session session = this.repository.login();
        Transaction t1 = this.transactionService.beginTransaction(session, "fedoraAdmin");
        Assert.assertNotNull((Object)t1);
        Assert.assertTrue((boolean)this.transactionService.exists(t1.getId()));
        Transaction t2 = this.transactionService.getTransaction(t1.getId(), "fedoraAdmin");
        Assert.assertNotNull((Object)t2);
        Assert.assertEquals((Object)t1.getId(), (Object)t2.getId());
    }

    @Test
    public void testTransactionExpire() throws RepositoryException {
        Session session = this.repository.login();
        Transaction t = this.transactionService.beginTransaction(session, "fedoraAdmin");
        String pid = this.getRandomPid();
        Session txSession = TxAwareSession.newInstance((Session)session, (String)t.getId());
        this.objectService.createObject(txSession, "/" + pid);
        t.expire();
        this.transactionService.removeAndRollbackExpired();
        Session session2 = this.repository.login();
        Assert.assertFalse((boolean)this.objectService.exists(session2, "/" + pid));
    }

    @Test
    public void testRollback() throws RepositoryException {
        Session session = this.repository.login();
        Transaction t = this.transactionService.beginTransaction(session, "fedoraAdmin");
        String pid = this.getRandomPid();
        Session txSession = TxAwareSession.newInstance((Session)session, (String)t.getId());
        this.objectService.createObject(txSession, "/" + pid);
        this.transactionService.rollback(t.getId());
        txSession.save();
        Session session2 = this.repository.login();
        Assert.assertFalse((boolean)this.objectService.exists(session2, "/" + pid));
    }

    @Test
    public void testCommit() throws RepositoryException {
        Session session = this.repository.login();
        Transaction t = this.transactionService.beginTransaction(session, "fedoraAdmin");
        String pid = this.getRandomPid();
        Session txSession = TxAwareSession.newInstance((Session)session, (String)t.getId());
        this.objectService.createObject(txSession, "/" + pid);
        this.transactionService.commit(t.getId());
        txSession.save();
        Session session2 = this.repository.login();
        Assert.assertTrue((boolean)this.objectService.exists(session2, "/" + pid));
    }
}

