/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.lock.LockManager;
import org.fcrepo.kernel.impl.LockReleasingSession;
import org.fcrepo.kernel.impl.TxAwareSession;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class LockReleasingSessionTest {
    private static final String LOCK_TOKEN = "t1";
    private static final String TX_ID = "TX1";
    @Mock
    private Session mockSession;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private LockManager mockLockManager;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockSession.isLive()).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getLockManager()).thenReturn((Object)this.mockLockManager);
        Mockito.when((Object)this.mockLockManager.getLockTokens()).thenReturn((Object)new String[]{LOCK_TOKEN});
    }

    @Test
    public void testDelegationOfOtherMethods() throws RepositoryException {
        Session proxySession = LockReleasingSession.newInstance((Session)this.mockSession);
        proxySession.save();
        ((Session)Mockito.verify((Object)this.mockSession, (VerificationMode)Mockito.never())).isLive();
        ((Session)Mockito.verify((Object)this.mockSession)).save();
    }

    @Test
    public void testDelegationOfLogoutMethod() throws RepositoryException {
        Session proxySession = LockReleasingSession.newInstance((Session)this.mockSession);
        proxySession.logout();
        ((Session)Mockito.verify((Object)this.mockSession)).isLive();
        Assert.assertTrue((boolean)this.mockSession.isLive());
        ((LockManager)Mockito.verify((Object)this.mockLockManager)).getLockTokens();
        ((LockManager)Mockito.verify((Object)this.mockLockManager)).removeLockToken(LOCK_TOKEN);
        ((Session)Mockito.verify((Object)this.mockSession)).logout();
    }

    @Test
    public void testTxSession() {
        Session txSession = TxAwareSession.newInstance((Session)this.mockSession, (String)TX_ID);
        Session proxySession = LockReleasingSession.newInstance((Session)txSession);
        proxySession.logout();
        ((Session)Mockito.verify((Object)this.mockSession, (VerificationMode)Mockito.never())).logout();
    }
}

