/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.observer.eventmappings;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.fcrepo.kernel.impl.observer.eventmappings.AllNodeEventsOneEvent;
import org.fcrepo.kernel.observer.FedoraEvent;
import org.fcrepo.kernel.utils.iterators.EventIterator;
import org.jgroups.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AllNodeEventsOneEventTest {
    private static final String TEST_IDENTIFIER1;
    private static final String TEST_PATH1 = "/test/node1";
    private static final String TEST_IDENTIFIER2;
    private static final String TEST_PATH2 = "/test/node1/property";
    private static final String TEST_IDENTIFIER3;
    private static final String TEST_PATH3 = "/test/node2";
    private final AllNodeEventsOneEvent testMapping = new AllNodeEventsOneEvent();
    @Mock
    private Event mockEvent1;
    @Mock
    private Event mockEvent2;
    @Mock
    private Event mockEvent3;
    @Mock
    private javax.jcr.observation.EventIterator mockIterator;
    private EventIterator testInput;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockEvent1.getIdentifier()).thenReturn((Object)TEST_IDENTIFIER1);
        Mockito.when((Object)this.mockEvent1.getPath()).thenReturn((Object)TEST_PATH1);
        Mockito.when((Object)this.mockEvent2.getIdentifier()).thenReturn((Object)TEST_IDENTIFIER2);
        Mockito.when((Object)this.mockEvent2.getPath()).thenReturn((Object)TEST_PATH2);
        Mockito.when((Object)this.mockEvent3.getIdentifier()).thenReturn((Object)TEST_IDENTIFIER3);
        Mockito.when((Object)this.mockEvent3.getPath()).thenReturn((Object)TEST_PATH3);
        Mockito.when((Object)this.mockEvent3.getType()).thenReturn((Object)16);
        Mockito.when((Object)this.mockIterator.next()).thenReturn((Object)this.mockEvent1, new Object[]{this.mockEvent2, this.mockEvent3});
        Mockito.when((Object)this.mockIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        this.testInput = new EventIterator(this.mockIterator);
    }

    @Test
    public void testCardinality() {
        Assert.assertEquals((String)"Didn't get 2 FedoraEvents for 3 input JCR Events, two of which were on the same node!", (long)2L, (long)Iterators.size((Iterator)this.testMapping.apply((Iterator)this.testInput)));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testBadOPeration() {
        this.testMapping.apply((Iterator)this.testInput).remove();
    }

    @Test(expected=RuntimeException.class)
    public void testBadEvent() throws RepositoryException {
        Mockito.reset((Object[])new Event[]{this.mockEvent1});
        Mockito.when((Object)this.mockEvent1.getIdentifier()).thenThrow(new Throwable[]{new RepositoryException("Expected.")});
        this.testMapping.apply((Iterator)this.testInput);
    }

    @Test
    public void testPropertyEvents() throws RepositoryException {
        Iterator iterator = this.testMapping.apply((Iterator)this.testInput);
        Assert.assertNotNull((Object)iterator);
        Assert.assertTrue((String)"Iterator is empty!", (boolean)iterator.hasNext());
        boolean found = false;
        while (iterator.hasNext()) {
            FedoraEvent event = (FedoraEvent)iterator.next();
            if (!TEST_IDENTIFIER3.equals(event.getIdentifier())) continue;
            Assert.assertEquals((String)"Expected one event property", (long)1L, (long)event.getProperties().size());
            found = true;
        }
        Assert.assertTrue((String)"Third mock event was not found!", (boolean)found);
    }

    @Test
    public void testError() throws RepositoryException {
        Mockito.when((Object)this.mockEvent3.getPath()).thenThrow(new Throwable[]{new RepositoryException("expected")});
        Iterator iterator = this.testMapping.apply((Iterator)this.testInput);
        Assert.assertNotNull((Object)iterator);
        Assert.assertEquals((String)"There should be 2 events!", (long)2L, (long)Iterators.size((Iterator)iterator));
    }

    static {
        TEST_IDENTIFIER2 = TEST_IDENTIFIER1 = UUID.randomUUID().toString();
        TEST_IDENTIFIER3 = UUID.randomUUID().toString();
    }
}

