/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf;

import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import org.fcrepo.kernel.impl.rdf.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;

public class SerializationUtilsTest {
    @Test
    public void testSetDatasetSubject() {
        Dataset dataset = DatasetFactory.create((Model)ModelFactory.createDefaultModel());
        SerializationUtils.setDatasetSubject((Dataset)dataset, (String)"some-uri");
        Assert.assertEquals((Object)"some-uri", (Object)dataset.getContext().getAsString(SerializationUtils.subjectKey));
    }

    @Test
    public void testGetDatasetSubject() {
        Dataset dataset = DatasetFactory.create((Model)ModelFactory.createDefaultModel());
        SerializationUtils.setDatasetSubject((Dataset)dataset, (String)"some-uri");
        Assert.assertEquals((Object)NodeFactory.createURI((String)"some-uri"), (Object)SerializationUtils.getDatasetSubject((Dataset)dataset));
    }

    @Test
    public void testGetDatasetSubjectWithoutContext() {
        Dataset dataset = DatasetFactory.create((Model)ModelFactory.createDefaultModel());
        Assert.assertEquals(null, (Object)SerializationUtils.getDatasetSubject((Dataset)dataset));
    }

    @Test
    public void testUnifyDatasetModels() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("a", "b");
        model.add(model.createResource(), model.createProperty("xyz"), "abc");
        Dataset dataset = DatasetFactory.create((Model)model);
        Model model2 = ModelFactory.createDefaultModel();
        model.add(model.createResource(), model.createProperty("abc"), "xyz");
        dataset.addNamedModel("xyz", model2);
        Model mergedModel = SerializationUtils.unifyDatasetModel((Dataset)dataset);
        Assert.assertEquals((Object)model.getNsPrefixMap(), (Object)mergedModel.getNsPrefixMap());
        Assert.assertTrue((boolean)mergedModel.containsAll(model));
        Assert.assertTrue((boolean)mergedModel.containsAll(model2));
    }
}

