/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class DefaultGraphSubjectsTest {
    private DefaultIdentifierTranslator testObj;
    @Mock
    Node mockNode;
    @Mock
    Resource mockSubject;
    @Mock
    Session mockSession;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new DefaultIdentifierTranslator();
    }

    @Test
    public void testGetGraphSubject() throws RepositoryException {
        String testPath = "/foo/bar";
        String expected = "info:fedora/" + "/foo/bar".substring(1);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/foo/bar");
        Resource actual = this.testObj.getSubject(this.mockNode.getPath());
        Assert.assertEquals((Object)expected, (Object)actual.getURI());
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/foo/bar/jcr:content");
        actual = this.testObj.getSubject(this.mockNode.getPath());
        Assert.assertEquals((Object)(expected + "/fcr:content"), (Object)actual.getURI());
    }

    @Test
    public void testGetNodeFromGraphSubject() throws RepositoryException {
        String expected = "/foo/bar";
        Mockito.when((Object)this.mockSession.nodeExists("/foo/bar")).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.nodeExists("/foo/bar/bad")).thenReturn((Object)false);
        Mockito.when((Object)this.mockSession.getNode("/foo/bar")).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)("info:fedora/" + "/foo/bar".substring(1)));
        Mockito.when((Object)this.mockSubject.isURIResource()).thenReturn((Object)true);
        Node actual = this.mockSession.getNode(this.testObj.getPathFromSubject(this.mockSubject));
        Assert.assertEquals((Object)this.mockNode, (Object)actual);
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)"info:fedora2/foo/bar/bad");
        actual = this.mockSession.getNode(this.testObj.getPathFromSubject(this.mockSubject));
        Assert.assertEquals((String)"Somehow got a Node from a bad RDF subject!", null, (Object)actual);
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)("info:fedora/" + "/foo/bar".substring(1) + "/bad"));
        actual = this.mockSession.getNode(this.testObj.getPathFromSubject(this.mockSubject));
        Assert.assertEquals((String)"Somehow got a Node from a non-existent RDF subject!", null, (Object)actual);
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)("info:fedora/" + "/foo/bar".substring(1) + "/fcr:content"));
        Mockito.when((Object)this.mockSession.nodeExists("/foo/bar/jcr:content")).thenReturn((Object)true);
        actual = this.mockSession.getNode(this.testObj.getPathFromSubject(this.mockSubject));
        ((Session)Mockito.verify((Object)this.mockSession)).getNode("/foo/bar/jcr:content");
    }

    @Test
    public void testGetPathFromGraphSubject() throws RepositoryException {
        String expected = "/foo/bar";
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)("info:fedora/" + "/foo/bar".substring(1)));
        Mockito.when((Object)this.mockSubject.isURIResource()).thenReturn((Object)true);
        String actual = this.testObj.getPathFromSubject(this.mockSubject);
        Assert.assertEquals((Object)"/foo/bar", (Object)actual);
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)("info:fedora2/" + "/foo/bar".substring(1) + "/bad"));
        actual = this.testObj.getPathFromSubject(this.mockSubject);
        Assert.assertNull((Object)actual);
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)("info:fedora/" + "/foo/bar".substring(1) + "/fcr:content"));
        actual = this.testObj.getPathFromSubject(this.mockSubject);
        Assert.assertEquals((Object)"/foo/bar/jcr:content", (Object)actual);
    }

    @Test
    public void testIsFedoraGraphSubject() {
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)"info:fedora/foo");
        Mockito.when((Object)this.mockSubject.isURIResource()).thenReturn((Object)true);
        boolean actual = this.testObj.isFedoraGraphSubject(this.mockSubject);
        Assert.assertEquals((Object)true, (Object)actual);
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)"http://fedora/foo");
        actual = this.testObj.isFedoraGraphSubject(this.mockSubject);
        Assert.assertEquals((Object)false, (Object)actual);
    }

    @Test(expected=NullPointerException.class)
    public void testIsFedoraGraphSubjectWithNull() {
        this.testObj.isFedoraGraphSubject(null);
    }

    @Test
    public void testIsFedoraGraphSubjectWithBlankNode() {
        Boolean actual = this.testObj.isFedoraGraphSubject(ResourceFactory.createResource());
        Assert.assertFalse((String)"Misrecognized an RDF blank node as a Fedora resource!", (boolean)actual);
    }

    @Test
    public void testGetContext() {
        Resource context = this.testObj.getContext();
        Assert.assertTrue((String)"Context was returned other than as an RDF blank node!", (boolean)context.isAnon());
    }
}

