/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.google.common.collect.Iterators;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.impl.rdf.impl.HierarchyRdfContext;
import org.fcrepo.kernel.impl.testutilities.TestNodeIterator;
import org.fcrepo.kernel.impl.testutilities.TestPropertyIterator;
import org.fcrepo.kernel.rdf.HierarchyRdfContextOptions;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchyRdfContextTest {
    private static final String MOCK_PARENT_NODE_PATH = "/mockNodeParent";
    private static final String MOCK_NODE_PATH = "/mockNodeParent/mockNode";
    private static final String MOCK_CHILD_NODE_PATH = "/mockNodeParent/mockNode/1";
    private static final String RESOURCE_PREFIX = "http://example.com";
    private static final Resource testPage = ResourceFactory.createResource((String)"http://example.com/page");
    private static final Resource testSubject = ResourceFactory.createResource((String)"http://example.com/mockNodeParent/mockNode");
    private static final Resource testParentSubject = ResourceFactory.createResource((String)"http://example.com/mockNodeParent");
    private static final Resource testChildSubject = ResourceFactory.createResource((String)"http://example.com/mockNodeParent/mockNode/1");
    private static final Resource testContentSubject = ResourceFactory.createResource((String)"/mockNodeParent/mockNodejcr:content");
    private static final String testBinaryKey = "testBinaryKey";
    private static final String testExternalIdentifier = "testExternalIdentifier";
    @Mock
    private Session mockSession;
    @Mock
    private Repository mockRepository;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private NamespaceRegistry mockNamespaceRegistry;
    @Mock
    private Node mockNode;
    @Mock
    private Node mockParentNode;
    @Mock
    private Node mockChildNode;
    @Mock
    private Node mockChildNode2;
    @Mock
    private Node mockChildNode3;
    @Mock
    private Node mockChildNode4;
    @Mock
    private Node mockChildNode5;
    @Mock
    private Node mockContentNode;
    @Mock
    private NodeIterator mockNodes;
    @Mock
    private NodeType mockNodeType;
    @Mock
    private IdentifierTranslator mockGraphSubjects;
    @Mock
    private BinaryValue mockBinary;
    @Mock
    private Property mockBinaryProperty;
    private static final Logger LOGGER = LoggerFactory.getLogger(HierarchyRdfContextTest.class);

    @Test
    public void testParentTriples() throws RepositoryException, IOException {
        this.nodeIsContainer();
        Mockito.when((Object)this.mockNode.hasNodes()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getDepth()).thenReturn((Object)1);
        Model actual = this.getResults();
        HierarchyRdfContextTest.logRdf("Retrieved RDF for testParentTriples(): ", actual);
        Assert.assertTrue((String)"Node doesn't have a parent!", (boolean)actual.contains(testSubject, RdfLexicon.HAS_PARENT, (RDFNode)testParentSubject));
    }

    @Test
    public void shouldIncludeChildNodeInformation() throws RepositoryException, IOException {
        this.nodeIsContainer();
        Mockito.when((Object)this.mockNode.hasNodes()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getDepth()).thenReturn((Object)0);
        this.buildChildNodes();
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)TestNodeIterator.nodeIterator(this.mockChildNode, this.mockChildNode2, this.mockChildNode3, this.mockChildNode4, this.mockChildNode5));
        this.mockNode.getNodes();
        Model actual = this.getResults();
        HierarchyRdfContextTest.logRdf("Retrieved RDF for shouldIncludeChildNodeInformation() as follows: ", actual);
        Assert.assertEquals((String)"Didn't find enough contains!", (long)5L, (long)Iterators.size((Iterator)actual.listObjectsOfProperty(RdfLexicon.CONTAINS)));
        Assert.assertEquals((String)"Didn't find enough children!", (long)5L, (long)Iterators.size((Iterator)actual.listObjectsOfProperty(RdfLexicon.HAS_CHILD)));
        Assert.assertEquals((String)"Found too many parents!", (long)1L, (long)Iterators.size((Iterator)actual.listObjectsOfProperty(RdfLexicon.HAS_PARENT)));
    }

    @Test
    public void testNodeWithContent() throws RepositoryException, IOException {
        this.buildContentNode();
        Mockito.when((Object)this.mockNode.hasNode("jcr:content")).thenReturn((Object)true);
        this.nodeIsContainer();
        Model actual = this.getResults();
        HierarchyRdfContextTest.logRdf("Created RDF for testNodeWithContent()", actual);
        Assert.assertFalse((String)"Should not have reported on content node!", (boolean)Iterators.contains((Iterator)actual.listSubjects(), (Object)testContentSubject.asNode()));
    }

    @Test
    public void testNotContainer() throws RepositoryException, IOException {
        this.nodeIsNotContainer();
        Mockito.when((Object)this.mockNode.hasNodes()).thenReturn((Object)false);
        Model actual = this.getResults();
        HierarchyRdfContextTest.logRdf("Created RDF for testNotContainer()", actual);
        Assert.assertFalse((boolean)actual.contains(testSubject, RDF.type, (RDFNode)RdfLexicon.CONTAINER));
        Assert.assertFalse((boolean)actual.contains(testSubject, RDF.type, (RDFNode)RdfLexicon.DIRECT_CONTAINER));
        Assert.assertFalse((boolean)actual.contains(testSubject, RdfLexicon.MEMBERSHIP_RESOURCE, (RDFNode)testSubject));
        Assert.assertFalse((boolean)actual.contains(testSubject, RdfLexicon.HAS_MEMBER_RELATION, (RDFNode)RdfLexicon.HAS_CHILD));
    }

    @Test
    public void testForLDPTriples() throws RepositoryException, IOException {
        this.nodeIsContainer();
        Mockito.when((Object)this.mockNode.hasNodes()).thenReturn((Object)false);
        Model results = this.getResults();
        HierarchyRdfContextTest.logRdf("Created RDF for testForLDPTriples()", results);
        Assert.assertTrue((String)"Didn't find node described as being the subject of membership!", (boolean)results.contains(testSubject, RdfLexicon.MEMBERSHIP_RESOURCE, (RDFNode)testSubject));
        Assert.assertTrue((String)"Didn't find node described as being an LDP Container!", (boolean)results.contains(testSubject, RDF.type, (RDFNode)RdfLexicon.CONTAINER));
        Assert.assertTrue((String)"Didn't find node described as being an LDP DirectContainer!", (boolean)results.contains(testSubject, RDF.type, (RDFNode)RdfLexicon.DIRECT_CONTAINER));
        Assert.assertTrue((String)"Didn't find node described as using the correct LDP membership predicate!", (boolean)results.contains(testSubject, RdfLexicon.HAS_MEMBER_RELATION, (RDFNode)RdfLexicon.HAS_CHILD));
    }

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockNode.getName()).thenReturn((Object)"mockNode");
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockGraphSubjects.getContext()).thenReturn((Object)testPage);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockParentNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNodeType.getName()).thenReturn((Object)"not:root");
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockParentNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)MOCK_NODE_PATH);
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockParentNode.getPath()).thenReturn((Object)MOCK_PARENT_NODE_PATH);
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockParentNode);
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)this.mockNodes);
        Mockito.when((Object)this.mockParentNode.hasProperties()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.hasProperties()).thenReturn((Object)false);
        Mockito.when((Object)this.mockGraphSubjects.getSubject(this.mockNode.getPath())).thenReturn((Object)testSubject);
        Mockito.when((Object)this.mockGraphSubjects.getSubject(this.mockParentNode.getPath())).thenReturn((Object)testParentSubject);
        Mockito.when((Object)this.mockGraphSubjects.getSubject(this.mockChildNode.getPath())).thenReturn((Object)testChildSubject);
        Mockito.when((Object)this.mockNodeType.isNodeType("mode:system")).thenReturn((Object)false);
        Mockito.when((Object)this.mockNodeType.getSupertypes()).thenReturn((Object)new NodeType[]{this.mockNodeType});
        Mockito.when((Object)this.mockSession.getRepository()).thenReturn((Object)this.mockRepository);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNamespaceRegistry);
        Mockito.when((Object)this.mockNamespaceRegistry.getURI("not")).thenReturn((Object)"http://www.jcp.org/jcr/1.0");
        Mockito.when((Object)this.mockParentNode.getSession()).thenReturn((Object)this.mockSession);
    }

    private void nodeIsContainer() {
        Mockito.when((Object)this.mockNodeType.getChildNodeDefinitions()).thenReturn((Object)new NodeDefinition[]{(NodeDefinition)Mockito.mock(NodeDefinition.class)});
    }

    private void nodeIsNotContainer() {
        Mockito.when((Object)this.mockNodeType.getChildNodeDefinitions()).thenReturn((Object)new NodeDefinition[0]);
    }

    private void buildChildNodes() throws RepositoryException {
        Mockito.when((Object)this.mockChildNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockChildNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockChildNode2.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockChildNode2.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockChildNode3.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockChildNode3.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockChildNode4.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockChildNode4.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockChildNode5.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockChildNode5.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockChildNode.hasProperties()).thenReturn((Object)false);
        Mockito.when((Object)this.mockChildNode2.hasProperties()).thenReturn((Object)false);
        Mockito.when((Object)this.mockChildNode3.hasProperties()).thenReturn((Object)false);
        Mockito.when((Object)this.mockChildNode4.hasProperties()).thenReturn((Object)false);
        Mockito.when((Object)this.mockChildNode5.hasProperties()).thenReturn((Object)false);
        Mockito.when((Object)this.mockChildNode.getName()).thenReturn((Object)"mockChildNode");
        Mockito.when((Object)this.mockChildNode2.getName()).thenReturn((Object)"mockChildNode2");
        Mockito.when((Object)this.mockChildNode3.getName()).thenReturn((Object)"mockChildNode3");
        Mockito.when((Object)this.mockChildNode4.getName()).thenReturn((Object)"mockChildNode4");
        Mockito.when((Object)this.mockChildNode5.getName()).thenReturn((Object)"mockChildNode5");
        Mockito.when((Object)this.mockChildNode.getParent()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockChildNode2.getParent()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockChildNode3.getParent()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockChildNode4.getParent()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockChildNode5.getParent()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockChildNode.getPath()).thenReturn((Object)MOCK_CHILD_NODE_PATH);
        Mockito.when((Object)this.mockChildNode2.getPath()).thenReturn((Object)"/mockNodeParent/mockNode/2");
        Mockito.when((Object)this.mockChildNode3.getPath()).thenReturn((Object)"/mockNodeParent/mockNode/3");
        Mockito.when((Object)this.mockChildNode4.getPath()).thenReturn((Object)"/mockNodeParent/mockNode/4");
        Mockito.when((Object)this.mockChildNode5.getPath()).thenReturn((Object)"/mockNodeParent/mockNode/5");
        Mockito.when((Object)this.mockGraphSubjects.getSubject(this.mockChildNode.getPath())).thenReturn((Object)ResourceFactory.createResource((String)"http://example.com/1"));
        Mockito.when((Object)this.mockGraphSubjects.getSubject(this.mockChildNode2.getPath())).thenReturn((Object)ResourceFactory.createResource((String)"http://example.com/2"));
        Mockito.when((Object)this.mockGraphSubjects.getSubject(this.mockChildNode3.getPath())).thenReturn((Object)ResourceFactory.createResource((String)"http://example.com/3"));
        Mockito.when((Object)this.mockGraphSubjects.getSubject(this.mockChildNode4.getPath())).thenReturn((Object)ResourceFactory.createResource((String)"http://example.com/4"));
        Mockito.when((Object)this.mockGraphSubjects.getSubject(this.mockChildNode5.getPath())).thenReturn((Object)ResourceFactory.createResource((String)"http://example.com/5"));
        Mockito.when((Object)this.mockChildNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockChildNode2.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockChildNode3.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockChildNode4.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockChildNode5.getSession()).thenReturn((Object)this.mockSession);
    }

    private void buildContentNode() throws RepositoryException {
        Mockito.when((Object)this.mockContentNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockContentNode.getPath()).thenReturn((Object)"/mockNodeParent/mockNodejcr:content");
        Mockito.when((Object)this.mockContentNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockContentNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockBinary.getKey()).thenReturn((Object)new BinaryKey(testBinaryKey));
        Mockito.when((Object)this.mockBinaryProperty.getBinary()).thenReturn((Object)this.mockBinary);
        Mockito.when((Object)this.mockContentNode.getProperty("jcr:data")).thenReturn((Object)this.mockBinaryProperty);
        Mockito.when((Object)this.mockBinaryProperty.getName()).thenReturn((Object)"jcr:data");
        Mockito.when((Object)this.mockBinaryProperty.getParent()).thenReturn((Object)this.mockContentNode);
        Mockito.when((Object)this.mockContentNode.getProperties()).thenReturn((Object)new TestPropertyIterator(this.mockBinaryProperty));
    }

    private Model getResults() throws RepositoryException {
        return this.getResults(HierarchyRdfContextOptions.DEFAULT);
    }

    private Model getResults(HierarchyRdfContextOptions options) throws RepositoryException {
        return new HierarchyRdfContext(this.mockNode, this.mockGraphSubjects, options).asModel();
    }

    private static void logRdf(String message, Model model) throws IOException {
        LOGGER.debug(message);
        try (StringWriter w = new StringWriter();){
            model.write((Writer)w);
            LOGGER.debug("\n" + ((Object)w).toString());
        }
    }
}

