/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.fcrepo.kernel.impl.rdf.impl.ReferencesRdfContext;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ReferencesRdfContextTest {
    public static final Resource NODE_A = ResourceFactory.createResource((String)"info:a");
    public static final Resource NODE_B = ResourceFactory.createResource((String)"info:b");
    @Mock
    private Property mockProperty;
    @Mock
    private Value mockValue;
    @Mock
    private Session mockSession;
    @Mock
    private Node mockOtherNode;
    @Mock
    private Node mockAnotherNode;
    @Mock
    private Node mockNode;
    @Mock
    private IdentifierTranslator mockGraphSubjects;
    @Mock
    private PropertyIterator mockReferences;
    @Mock
    private PropertyIterator emptyPropertyIterator;

    @Test
    public void testForStrongReferencesTriples() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getReferences()).thenReturn((Object)this.mockReferences);
        Mockito.when((Object)this.mockNode.getWeakReferences()).thenReturn((Object)this.emptyPropertyIterator);
        Mockito.when((Object)this.mockReferences.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)this.mockReferences.next()).thenReturn((Object)this.mockProperty);
        ReferencesRdfContext triples = new ReferencesRdfContext(this.mockNode, this.mockGraphSubjects);
        Model model = triples.asModel();
        Assert.assertTrue((boolean)model.contains(NODE_B, ResourceFactory.createProperty((String)"some-property"), (RDFNode)NODE_A));
    }

    @Test
    public void testForWeakReferencesTriples() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getWeakReferences()).thenReturn((Object)this.mockReferences);
        Mockito.when((Object)this.mockNode.getReferences()).thenReturn((Object)this.emptyPropertyIterator);
        Mockito.when((Object)this.mockReferences.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)this.mockReferences.next()).thenReturn((Object)this.mockProperty);
        ReferencesRdfContext triples = new ReferencesRdfContext(this.mockNode, this.mockGraphSubjects);
        Model model = triples.asModel();
        Assert.assertTrue((boolean)model.contains(NODE_B, ResourceFactory.createProperty((String)"some-property"), (RDFNode)NODE_A));
    }

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"a");
        Mockito.when((Object)this.mockOtherNode.getPath()).thenReturn((Object)"b");
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)"some-property");
        Mockito.when((Object)this.mockProperty.getParent()).thenReturn((Object)this.mockOtherNode);
        Mockito.when((Object)this.mockProperty.getNode()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockProperty.getValue()).thenReturn((Object)this.mockValue);
        Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)9);
        Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)"some-uuid");
        Mockito.when((Object)this.mockProperty.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getNodeByIdentifier("some-uuid")).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockGraphSubjects.getSubject("a")).thenReturn((Object)NODE_A);
        Mockito.when((Object)this.mockGraphSubjects.getSubject("b")).thenReturn((Object)NODE_B);
        Mockito.when((Object)this.emptyPropertyIterator.hasNext()).thenReturn((Object)false);
    }
}

