/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.impl.rdf.impl.WorkspaceRdfContext;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class WorkspaceRdfContextTest {
    @Mock
    private IdentifierTranslator subjects;
    @Mock
    private Session session;
    @Mock
    private Repository repository;
    @Mock
    private Workspace mockWorkspace;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.subjects = new DefaultIdentifierTranslator();
        Mockito.when((Object)this.session.getRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)this.mockWorkspace);
    }

    @Test
    public void testWorkspaceTriples() throws RepositoryException {
        Mockito.when((Object)this.mockWorkspace.getAccessibleWorkspaceNames()).thenReturn((Object)new String[]{"default", "a", "b"});
        WorkspaceRdfContext testObj = new WorkspaceRdfContext(this.session, this.subjects);
        Model model = testObj.asModel();
        Assert.assertTrue((boolean)model.contains(this.subjects.getSubject("/"), RdfLexicon.HAS_DEFAULT_WORKSPACE, (RDFNode)this.subjects.getSubject("/workspace:default")));
        Assert.assertTrue((boolean)model.contains(this.subjects.getSubject("/workspace:default"), RdfLexicon.DC_TITLE, "default"));
        Assert.assertTrue((boolean)model.contains(this.subjects.getSubject("/"), RdfLexicon.HAS_WORKSPACE, (RDFNode)this.subjects.getSubject("/workspace:a")));
        Assert.assertTrue((boolean)model.contains(this.subjects.getSubject("/"), RdfLexicon.HAS_WORKSPACE, (RDFNode)this.subjects.getSubject("/workspace:b")));
    }
}

