/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import com.google.common.collect.ImmutableSet;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.InputStream;
import java.net.URI;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.jcr.FedoraJcrTypes;
import org.fcrepo.kernel.Datastream;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.impl.services.DatastreamServiceImpl;
import org.fcrepo.kernel.impl.utils.impl.CacheEntryFactory;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.services.DatastreamService;
import org.fcrepo.kernel.services.policy.StoragePolicyDecisionPoint;
import org.fcrepo.kernel.utils.CacheEntry;
import org.fcrepo.kernel.utils.FixityResult;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.ValueFactory;
import org.modeshape.jcr.value.binary.StoredBinaryValue;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "org.apache.xerces.*", "javax.xml.*", "org.xml.sax.*", "javax.management.*"})
@PrepareForTest(value={JcrRdfTools.class, CacheEntryFactory.class})
public class DatastreamServiceImplTest
implements FedoraJcrTypes {
    private static final String MOCK_CONTENT_TYPE = "application/test-data";
    private static final String JCR_CONTENT = "jcr:content";
    private static final String JCR_DATA = "jcr:data";
    @Mock
    private Session mockSession;
    @Mock
    private Node mockRoot;
    @Mock
    private Node mockNode;
    @Mock
    private Node mockContent;
    @Mock
    private Property mockProperty;
    @Mock
    private StoredBinaryValue mockBinary;
    private DatastreamService testObj;
    @Mock
    private ValueFactory mockValueFactory;
    @Mock
    private Property mockData;
    @Mock
    private javax.jcr.Binary mockBinaryValue;
    @Mock
    private Repository mockRepository;
    @Mock
    private CacheEntry mockCacheEntry;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new DatastreamServiceImpl();
        this.testObj.setRepository(this.mockRepository);
        Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRoot);
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        NodeType mockNodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)mockNodeType.getName()).thenReturn((Object)"nt:file");
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)mockNodeType);
    }

    @Test
    public void testCreateDatastreamNode() throws Exception {
        String testPath = "/foo/bar";
        Property mockData = (Property)Mockito.mock(Property.class);
        Binary mockBinary = (Binary)Mockito.mock(Binary.class);
        Mockito.when((Object)this.mockRoot.getNode("/foo/bar".substring(1))).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.getNode(JCR_CONTENT)).thenReturn((Object)this.mockContent);
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)mockData.getBinary()).thenReturn((Object)mockBinary);
        InputStream mockIS = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)this.mockContent.setProperty(JCR_DATA, (javax.jcr.Binary)mockBinary)).thenReturn((Object)mockData);
        Mockito.when((Object)this.mockContent.getProperty(JCR_DATA)).thenReturn((Object)mockData);
        StoragePolicyDecisionPoint pdp = (StoragePolicyDecisionPoint)Mockito.mock(StoragePolicyDecisionPoint.class);
        Mockito.when((Object)pdp.evaluatePolicies(this.mockNode)).thenReturn(null);
        ((DatastreamServiceImpl)this.testObj).setStoragePolicyDecisionPoint(pdp);
        Mockito.when((Object)this.mockNode.getSession().getValueFactory()).thenReturn((Object)this.mockValueFactory);
        Mockito.when((Object)this.mockValueFactory.createBinary((InputStream)Matchers.any(InputStream.class), (String)Matchers.any(String.class))).thenReturn((Object)mockBinary);
        Datastream actual = this.testObj.createDatastream(this.mockSession, "/foo/bar", MOCK_CONTENT_TYPE, "xyz.jpg", mockIS);
        Assert.assertEquals((Object)this.mockNode, (Object)actual.getNode());
        ((Node)Mockito.verify((Object)this.mockContent)).setProperty(JCR_DATA, (javax.jcr.Binary)mockBinary);
        ((Node)Mockito.verify((Object)this.mockContent)).setProperty("premis:hasOriginalName", "xyz.jpg");
    }

    @Test
    public void testGetDatastreamNode() throws Exception {
        String testPath = "/foo/bar";
        NodeType mockNodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)mockNodeType.getName()).thenReturn((Object)"fedora:datastream");
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{mockNodeType});
        Mockito.when((Object)this.mockSession.getNode("/foo/bar")).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockRoot.getNode("/foo/bar".substring(1))).thenReturn((Object)this.mockNode);
        DatastreamServiceImpl testObj = new DatastreamServiceImpl();
        testObj.getDatastreamNode(this.mockSession, "/foo/bar");
        ((Node)Mockito.verify((Object)this.mockRoot)).getNode("/foo/bar".substring(1));
    }

    @Test
    public void testGetDatastream() throws Exception {
        String testPath = "/foo/bar";
        NodeType mockNodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)mockNodeType.getName()).thenReturn((Object)"fedora:datastream");
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{mockNodeType});
        Mockito.when((Object)this.mockRoot.getNode("/foo/bar".substring(1))).thenReturn((Object)this.mockNode);
        this.testObj.getDatastream(this.mockSession, "/foo/bar");
        ((Node)Mockito.verify((Object)this.mockRoot)).getNode("/foo/bar".substring(1));
    }

    @Test
    public void testGetFixityResultsModel() throws Exception {
        PowerMockito.mockStatic(CacheEntryFactory.class, (Class[])new Class[0]);
        IdentifierTranslator mockSubjects = (IdentifierTranslator)Mockito.mock(IdentifierTranslator.class);
        Mockito.when((Object)mockSubjects.getSubject(this.mockNode.getPath())).thenReturn((Object)ResourceFactory.createResource((String)"abc"));
        FixityResult fixityResult = (FixityResult)Mockito.mock(FixityResult.class);
        Mockito.when((Object)fixityResult.matches(((Long)Matchers.any(Long.class)).longValue(), (URI)Matchers.any(URI.class))).thenReturn((Object)true);
        ImmutableSet fixityResults = ImmutableSet.of((Object)fixityResult);
        Datastream mockDatastream = (Datastream)Mockito.mock(Datastream.class);
        Mockito.when((Object)this.mockNode.getNode(JCR_CONTENT)).thenReturn((Object)this.mockContent);
        Mockito.when((Object)this.mockContent.getProperty(JCR_DATA)).thenReturn((Object)this.mockProperty);
        Mockito.when((Object)this.mockProperty.getBinary()).thenReturn((Object)this.mockBinary);
        Mockito.when((Object)mockDatastream.getNode()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)mockDatastream.getContentDigest()).thenReturn((Object)new URI("urn:sha1:abc"));
        Mockito.when((Object)CacheEntryFactory.forProperty((Repository)this.mockRepository, (Property)this.mockProperty)).thenReturn((Object)this.mockCacheEntry);
        Mockito.when((Object)this.mockCacheEntry.checkFixity((URI)Matchers.any(URI.class), ((Long)Matchers.any(Long.class)).longValue())).thenReturn((Object)fixityResults);
        RdfStream actual = this.testObj.getFixityResultsModel(mockSubjects, mockDatastream);
        Assert.assertEquals((String)"Got wrong topic of fixity results!", (Object)ResourceFactory.createResource((String)"abc").asNode(), (Object)actual.topic());
    }
}

