/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.fcrepo.kernel.impl.services.ExternalContentServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={HttpClients.class})
public class ExternalContentServiceImplTest {
    private ExternalContentServiceImpl testObj;
    @Mock
    private HttpClientConnectionManager mockClientPool;
    @Mock
    private CloseableHttpClient mockClient;
    private URI sourceUri;
    @Mock
    private CloseableHttpResponse mockResponse;
    @Mock
    private HttpEntity mockEntity;
    @Mock
    private InputStream mockInputStream;

    @Before
    public void setUp() throws URISyntaxException, IOException {
        MockitoAnnotations.initMocks((Object)this);
        this.sourceUri = new URI("http://localhost:8080/xyz");
        this.testObj = new ExternalContentServiceImpl();
        this.testObj.setConnManager(this.mockClientPool);
        PowerMockito.mockStatic(HttpClients.class, (Class[])new Class[0]);
        PowerMockito.when((Object)HttpClients.createMinimal((HttpClientConnectionManager)this.mockClientPool)).thenReturn((Object)this.mockClient);
        PowerMockito.when((Object)this.mockClient.execute((HttpUriRequest)Mockito.any(HttpGet.class))).thenReturn((Object)this.mockResponse);
        PowerMockito.when((Object)this.mockResponse.getEntity()).thenReturn((Object)this.mockEntity);
        PowerMockito.when((Object)this.mockEntity.getContent()).thenReturn((Object)this.mockInputStream);
    }

    @Test
    public void testRetrieveExternalContent() throws Exception {
        InputStream xyz = this.testObj.retrieveExternalContent(this.sourceUri);
        Assert.assertEquals((Object)this.mockInputStream, (Object)xyz);
    }
}

