/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.util.Collections;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.fcrepo.kernel.Transaction;
import org.fcrepo.kernel.impl.services.TransactionServiceImpl;
import org.fcrepo.kernel.impl.services.VersionServiceImpl;
import org.fcrepo.kernel.services.TransactionService;
import org.fcrepo.kernel.services.VersionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class VersionServiceImplTest {
    private static final String USER_NAME = "test";
    public static final String EXAMPLE_VERSIONED_PATH = "/example-versioned";
    public static final String EXAMPLE_AUTO_VERSIONED_PATH = "/example-auto-versioned";
    public static final String EXAMPLE_UNVERSIONED_PATH = "/example-unversioned";
    private VersionService testObj;
    private TransactionService txService;
    @Mock
    private Session s;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private VersionManager mockVM;

    @Before
    public void setup() throws Exception {
        this.txService = new TransactionServiceImpl();
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new VersionServiceImpl();
        this.testObj.setTxService(this.txService);
        this.txService.setVersionService(this.testObj);
        this.s = (Session)Mockito.mock(Session.class);
        this.mockWorkspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.mockWorkspace.getSession()).thenReturn((Object)this.s);
        Mockito.when((Object)this.mockWorkspace.getName()).thenReturn((Object)"default");
        Mockito.when((Object)this.s.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        this.mockVM = (VersionManager)Mockito.mock(VersionManager.class);
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)this.mockVM);
        Node versionedNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)versionedNode.getPath()).thenReturn((Object)EXAMPLE_VERSIONED_PATH);
        Mockito.when((Object)versionedNode.getSession()).thenReturn((Object)this.s);
        Mockito.when((Object)versionedNode.isNodeType("mix:versionable")).thenReturn((Object)true);
        Mockito.when((Object)this.s.getNode(EXAMPLE_VERSIONED_PATH)).thenReturn((Object)versionedNode);
        Node autoversionedNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)autoversionedNode.getPath()).thenReturn((Object)EXAMPLE_AUTO_VERSIONED_PATH);
        Mockito.when((Object)autoversionedNode.getSession()).thenReturn((Object)this.s);
        Mockito.when((Object)autoversionedNode.isNodeType("mix:versionable")).thenReturn((Object)true);
        Mockito.when((Object)this.s.getNode(EXAMPLE_AUTO_VERSIONED_PATH)).thenReturn((Object)autoversionedNode);
        Property autoVersionProperty = (Property)Mockito.mock(Property.class);
        Value autoVersionValue = (Value)Mockito.mock(Value.class);
        Mockito.when((Object)autoVersionValue.getString()).thenReturn((Object)"auto-version");
        Mockito.when((Object)autoVersionProperty.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)autoVersionProperty.getValues()).thenReturn((Object)new Value[]{autoVersionValue});
        Mockito.when((Object)autoversionedNode.hasProperty("fedoraconfig:versioningPolicy")).thenReturn((Object)true);
        Mockito.when((Object)autoversionedNode.getProperty("fedoraconfig:versioningPolicy")).thenReturn((Object)autoVersionProperty);
        Node unversionedNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)unversionedNode.getPath()).thenReturn((Object)EXAMPLE_UNVERSIONED_PATH);
        Mockito.when((Object)unversionedNode.getSession()).thenReturn((Object)this.s);
        Mockito.when((Object)unversionedNode.isNodeType("mix:versionable")).thenReturn((Object)false);
        Mockito.when((Object)this.s.getNode(EXAMPLE_UNVERSIONED_PATH)).thenReturn((Object)unversionedNode);
    }

    @Test
    public void testUpdateVersioned() throws Exception {
        this.testObj.nodeUpdated(this.s, EXAMPLE_VERSIONED_PATH);
        ((VersionManager)Mockito.verify((Object)this.mockVM, (VerificationMode)Mockito.never())).checkpoint(EXAMPLE_VERSIONED_PATH);
    }

    @Test
    public void testUpdateUnversioned() throws Exception {
        this.testObj.nodeUpdated(this.s, EXAMPLE_UNVERSIONED_PATH);
        ((VersionManager)Mockito.verify((Object)this.mockVM, (VerificationMode)Mockito.never())).checkpoint(EXAMPLE_UNVERSIONED_PATH);
    }

    @Test
    public void testUpdateAutoVersioned() throws Exception {
        this.testObj.nodeUpdated(this.s, EXAMPLE_AUTO_VERSIONED_PATH);
        ((VersionManager)Mockito.verify((Object)this.mockVM, (VerificationMode)Mockito.only())).checkpoint(EXAMPLE_AUTO_VERSIONED_PATH);
    }

    @Test
    public void testDeferredCheckpointVersioned() throws Exception {
        Transaction t = this.txService.beginTransaction(this.s, USER_NAME);
        this.s = t.getSession();
        Mockito.when((Object)this.s.getNamespaceURI("fcrepo4.tx.id")).thenReturn((Object)t.getId());
        Assert.assertNotNull((String)"Transaction must have started!", (Object)this.txService.getTransaction(this.s.getNode(EXAMPLE_AUTO_VERSIONED_PATH).getSession()));
        this.testObj.nodeUpdated(this.s, EXAMPLE_VERSIONED_PATH);
        ((VersionManager)Mockito.verify((Object)this.mockVM, (VerificationMode)Mockito.never())).checkpoint(EXAMPLE_VERSIONED_PATH);
        this.txService.commit(t.getId());
        ((VersionManager)Mockito.verify((Object)this.mockVM, (VerificationMode)Mockito.never())).checkpoint(EXAMPLE_VERSIONED_PATH);
    }

    @Test
    public void testDeferredCheckpointUnversioned() throws Exception {
        Transaction t = this.txService.beginTransaction(this.s, USER_NAME);
        this.s = t.getSession();
        Mockito.when((Object)this.s.getNamespaceURI("fcrepo4.tx.id")).thenReturn((Object)t.getId());
        Assert.assertNotNull((String)"Transaction must have started!", (Object)this.txService.getTransaction(this.s.getNode(EXAMPLE_AUTO_VERSIONED_PATH).getSession()));
        this.testObj.nodeUpdated(this.s, EXAMPLE_UNVERSIONED_PATH);
        ((VersionManager)Mockito.verify((Object)this.mockVM, (VerificationMode)Mockito.never())).checkpoint(EXAMPLE_UNVERSIONED_PATH);
        this.txService.commit(t.getId());
        ((VersionManager)Mockito.verify((Object)this.mockVM, (VerificationMode)Mockito.never())).checkpoint(EXAMPLE_UNVERSIONED_PATH);
    }

    @Test
    public void testDeferredCheckpointAutoVersioned() throws Exception {
        Transaction t = this.txService.beginTransaction(this.s, USER_NAME);
        this.s = t.getSession();
        Mockito.when((Object)this.s.getNamespaceURI("fcrepo4.tx.id")).thenReturn((Object)t.getId());
        Assert.assertNotNull((String)"Transaction must have started!", (Object)this.txService.getTransaction(this.s.getNode(EXAMPLE_AUTO_VERSIONED_PATH).getSession()));
        this.testObj.nodeUpdated(this.s, EXAMPLE_AUTO_VERSIONED_PATH);
        ((VersionManager)Mockito.verify((Object)this.mockVM, (VerificationMode)Mockito.never())).checkpoint(EXAMPLE_AUTO_VERSIONED_PATH);
        this.txService.commit(t.getId());
        ((VersionManager)Mockito.verify((Object)this.mockVM, (VerificationMode)Mockito.only())).checkpoint(EXAMPLE_AUTO_VERSIONED_PATH);
    }

    @Test
    public void testRevertToVersionByLabel() throws RepositoryException {
        String versionLabel = "v";
        VersionManager mockVersionManager = (VersionManager)Mockito.mock(VersionManager.class);
        VersionHistory mockHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Version mockVersion1 = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)mockHistory.hasVersionLabel("v")).thenReturn((Object)true);
        Mockito.when((Object)mockHistory.getVersionByLabel("v")).thenReturn((Object)mockVersion1);
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)mockVersionManager);
        Mockito.when((Object)mockVersionManager.getVersionHistory(EXAMPLE_VERSIONED_PATH)).thenReturn((Object)mockHistory);
        this.testObj.revertToVersion(this.mockWorkspace, EXAMPLE_VERSIONED_PATH, "v");
        ((VersionManager)Mockito.verify((Object)mockVersionManager)).restore(mockVersion1, true);
        ((VersionManager)Mockito.verify((Object)mockVersionManager, (VerificationMode)Mockito.never())).checkpoint(EXAMPLE_VERSIONED_PATH);
    }

    @Test
    public void testRevertToVersionByUUID() throws RepositoryException {
        String versionUUID = "uuid";
        VersionManager mockVersionManager = (VersionManager)Mockito.mock(VersionManager.class);
        VersionHistory mockHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Version mockVersion1 = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)mockHistory.getVersionByLabel("uuid")).thenThrow(new Class[]{VersionException.class});
        VersionIterator mockVersionIterator = (VersionIterator)Mockito.mock(VersionIterator.class);
        Mockito.when((Object)mockHistory.getAllVersions()).thenReturn((Object)mockVersionIterator);
        Mockito.when((Object)mockVersionIterator.hasNext()).thenReturn((Object)true);
        Mockito.when((Object)mockVersionIterator.nextVersion()).thenReturn((Object)mockVersion1);
        Node mockFrozenNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)mockVersion1.getFrozenNode()).thenReturn((Object)mockFrozenNode);
        Mockito.when((Object)mockFrozenNode.getIdentifier()).thenReturn((Object)"uuid");
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)mockVersionManager);
        Mockito.when((Object)mockVersionManager.getVersionHistory(EXAMPLE_VERSIONED_PATH)).thenReturn((Object)mockHistory);
        this.testObj.revertToVersion(this.mockWorkspace, EXAMPLE_VERSIONED_PATH, "uuid");
        ((VersionManager)Mockito.verify((Object)mockVersionManager)).restore(mockVersion1, true);
    }

    @Test(expected=PathNotFoundException.class)
    public void testRevertToUnknownVersion() throws RepositoryException {
        String versionUUID = "uuid";
        VersionManager mockVersionManager = (VersionManager)Mockito.mock(VersionManager.class);
        VersionHistory mockHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Mockito.when((Object)mockHistory.getVersionByLabel("uuid")).thenThrow(new Class[]{VersionException.class});
        VersionIterator mockVersionIterator = (VersionIterator)Mockito.mock(VersionIterator.class);
        Mockito.when((Object)mockHistory.getAllVersions()).thenReturn((Object)mockVersionIterator);
        Mockito.when((Object)mockVersionIterator.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)mockVersionManager);
        Mockito.when((Object)mockVersionManager.getVersionHistory(EXAMPLE_VERSIONED_PATH)).thenReturn((Object)mockHistory);
        this.testObj.revertToVersion(this.mockWorkspace, EXAMPLE_VERSIONED_PATH, "uuid");
    }

    @Test
    public void testRevertToVersionByLabelWithAutoVersioning() throws RepositoryException {
        String versionLabel = "v";
        VersionManager mockVersionManager = (VersionManager)Mockito.mock(VersionManager.class);
        VersionHistory mockHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Version mockVersion1 = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)mockHistory.hasVersionLabel("v")).thenReturn((Object)true);
        Mockito.when((Object)mockHistory.getVersionByLabel("v")).thenReturn((Object)mockVersion1);
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)mockVersionManager);
        Mockito.when((Object)mockVersionManager.getVersionHistory(EXAMPLE_AUTO_VERSIONED_PATH)).thenReturn((Object)mockHistory);
        this.testObj.revertToVersion(this.mockWorkspace, EXAMPLE_AUTO_VERSIONED_PATH, "v");
        ((VersionManager)Mockito.verify((Object)mockVersionManager)).restore(mockVersion1, true);
        ((VersionManager)Mockito.verify((Object)mockVersionManager)).checkpoint(EXAMPLE_AUTO_VERSIONED_PATH);
    }

    @Test
    public void testRemoveVersionByLabel() throws RepositoryException {
        String versionLabel = "versionName";
        String versionUUID = "uuid";
        String versionName = "Bob";
        String[] versionLabels = new String[]{"versionName"};
        VersionManager mockVersionManager = (VersionManager)Mockito.mock(VersionManager.class);
        VersionHistory mockHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Version mockVersion1 = (Version)Mockito.mock(Version.class);
        Version mockVersion2 = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)mockVersion1.getContainingHistory()).thenReturn((Object)mockHistory);
        Mockito.when((Object)mockHistory.hasVersionLabel("versionName")).thenReturn((Object)true);
        Mockito.when((Object)mockHistory.getVersionByLabel("versionName")).thenReturn((Object)mockVersion1);
        Mockito.when((Object)mockHistory.getVersionLabels(mockVersion1)).thenReturn((Object)versionLabels);
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)mockVersionManager);
        Mockito.when((Object)mockVersionManager.getVersionHistory("/example")).thenReturn((Object)mockHistory);
        Mockito.when((Object)mockVersionManager.getBaseVersion("/example")).thenReturn((Object)mockVersion2);
        Node mockFrozenNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)mockVersion1.getFrozenNode()).thenReturn((Object)mockFrozenNode);
        Mockito.when((Object)mockFrozenNode.getIdentifier()).thenReturn((Object)"uuid");
        Mockito.when((Object)mockVersion1.getIdentifier()).thenReturn((Object)"uuid");
        Mockito.when((Object)mockVersion1.getName()).thenReturn((Object)"Bob");
        this.testObj.removeVersion(this.mockWorkspace, "/example", "versionName");
        ((VersionHistory)Mockito.verify((Object)mockHistory)).removeVersion("Bob");
        ((VersionHistory)Mockito.verify((Object)mockHistory)).removeVersionLabel("versionName");
        ((VersionManager)Mockito.verify((Object)mockVersionManager, (VerificationMode)Mockito.never())).checkpoint("/example");
    }

    @Test
    public void testRemoveVersionByUUID() throws RepositoryException {
        String versionName = "Bob";
        String versionUUID = "uuid";
        String[] versionLabels = new String[]{};
        VersionManager mockVersionManager = (VersionManager)Mockito.mock(VersionManager.class);
        VersionHistory mockHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Version mockVersion1 = (Version)Mockito.mock(Version.class);
        Version mockVersion2 = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)mockVersion1.getContainingHistory()).thenReturn((Object)mockHistory);
        Mockito.when((Object)mockHistory.getVersionByLabel("uuid")).thenThrow(new Class[]{VersionException.class});
        VersionIterator mockVersionIterator = (VersionIterator)Mockito.mock(VersionIterator.class);
        Mockito.when((Object)mockHistory.getAllVersions()).thenReturn((Object)mockVersionIterator);
        Mockito.when((Object)mockHistory.getVersionLabels(mockVersion1)).thenReturn((Object)versionLabels);
        Mockito.when((Object)mockVersionIterator.hasNext()).thenReturn((Object)true);
        Mockito.when((Object)mockVersionIterator.nextVersion()).thenReturn((Object)mockVersion1);
        Node mockFrozenNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)mockVersion1.getFrozenNode()).thenReturn((Object)mockFrozenNode);
        Mockito.when((Object)mockFrozenNode.getIdentifier()).thenReturn((Object)"uuid");
        Mockito.when((Object)mockVersion1.getIdentifier()).thenReturn((Object)"uuid");
        Mockito.when((Object)mockVersion1.getName()).thenReturn((Object)"Bob");
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)mockVersionManager);
        Mockito.when((Object)mockVersionManager.getVersionHistory("/example")).thenReturn((Object)mockHistory);
        Mockito.when((Object)mockVersionManager.getBaseVersion("/example")).thenReturn((Object)mockVersion2);
        this.testObj.removeVersion(this.mockWorkspace, "/example", "uuid");
        ((VersionHistory)Mockito.verify((Object)mockHistory)).removeVersion("Bob");
    }

    @Test(expected=PathNotFoundException.class)
    public void testRemoveUnknownVersion() throws RepositoryException {
        String versionUUID = "uuid";
        VersionManager mockVersionManager = (VersionManager)Mockito.mock(VersionManager.class);
        VersionHistory mockHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Mockito.when((Object)mockHistory.getVersionByLabel("uuid")).thenThrow(new Class[]{VersionException.class});
        VersionIterator mockVersionIterator = (VersionIterator)Mockito.mock(VersionIterator.class);
        Mockito.when((Object)mockHistory.getAllVersions()).thenReturn((Object)mockVersionIterator);
        Mockito.when((Object)mockVersionIterator.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)mockVersionManager);
        Mockito.when((Object)mockVersionManager.getVersionHistory("/example")).thenReturn((Object)mockHistory);
        this.testObj.removeVersion(this.mockWorkspace, "/example", "uuid");
    }

    @Test
    public void testMixinCreationWhenExplicitlyVersioning() throws RepositoryException {
        this.testObj.createVersion(this.mockWorkspace, Collections.singleton(EXAMPLE_UNVERSIONED_PATH));
        Node unversionedNode = this.s.getNode(EXAMPLE_UNVERSIONED_PATH);
        ((Node)Mockito.verify((Object)unversionedNode)).isNodeType("mix:versionable");
        ((Node)Mockito.verify((Object)unversionedNode)).addMixin("mix:versionable");
    }

    @Test
    public void testMixinCreationWhenAutoVersioningIsTurnedOn() throws RepositoryException {
        Node unversionedNode = this.s.getNode(EXAMPLE_UNVERSIONED_PATH);
        Property mockProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)unversionedNode.hasProperty("fedoraconfig:versioningPolicy")).thenReturn((Object)true);
        Mockito.when((Object)unversionedNode.getProperty("fedoraconfig:versioningPolicy")).thenReturn((Object)mockProperty);
        Mockito.when((Object)mockProperty.getString()).thenReturn((Object)"auto-version");
        this.testObj.nodeUpdated(this.s, EXAMPLE_UNVERSIONED_PATH);
        ((Node)Mockito.verify((Object)unversionedNode)).isNodeType("mix:versionable");
        ((Node)Mockito.verify((Object)unversionedNode)).addMixin("mix:versionable");
    }
}

