/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.spring;

import java.io.File;
import org.fcrepo.kernel.impl.spring.DefaultPropertiesLoader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultPropertiesLoaderTest {
    private DefaultPropertiesLoader loader;
    private static final String PROP_FLAG = "integration-test";
    private static final String PROP_TEST = "fcrepo.ispn.repo.CacheDirPath";
    private static final String HOME_PROP = "fcrepo.home";

    @Before
    public void setUp() throws Exception {
        this.loader = new DefaultPropertiesLoader();
    }

    @After
    public void tearDown() throws Exception {
        DefaultPropertiesLoaderTest.clearProps();
    }

    private static void clearProps() {
        System.clearProperty(PROP_FLAG);
        System.clearProperty(PROP_TEST);
        System.clearProperty(HOME_PROP);
    }

    @Test
    public void testLoadSystemProperties() throws Exception {
        System.setProperty(PROP_FLAG, "true");
        this.loader.loadSystemProperties();
        Assert.assertNotNull((Object)System.getProperty(PROP_FLAG));
        Assert.assertNull((Object)System.getProperty(PROP_TEST));
    }

    @Test
    public void testLoadSystemPropertiesProduction() throws Exception {
        this.loader.loadSystemProperties();
        Assert.assertNull((Object)System.getProperty(PROP_FLAG));
        Assert.assertNotNull((Object)System.getProperty(PROP_TEST));
    }

    @Test
    public void testContentIsInWorkingDir() {
        this.loader.loadSystemProperties();
        Assert.assertTrue((String)"Default directories are within working directory.", (boolean)DefaultPropertiesLoaderTest.containsPath(System.getProperty(PROP_TEST), System.getProperty("user.dir")));
    }

    @Test
    public void testCustomHomeDirWithRelativeSubdirs() {
        System.setProperty(HOME_PROP, DefaultPropertiesLoaderTest.asTempPath("test"));
        System.setProperty(PROP_TEST, "sub");
        this.loader.loadSystemProperties();
        File home = new File(DefaultPropertiesLoaderTest.asTempPath("test"));
        Assert.assertTrue((String)"Relative subdirs are within fcrepo.home directory.", (boolean)DefaultPropertiesLoaderTest.containsPath(System.getProperty(PROP_TEST), home.getAbsolutePath()));
        DefaultPropertiesLoaderTest.clearProps();
    }

    @Test
    public void testCustomHomeDirWithAbsoluteSubdirs() {
        System.setProperty(HOME_PROP, DefaultPropertiesLoaderTest.asTempPath("test"));
        System.setProperty(PROP_TEST, DefaultPropertiesLoaderTest.asTempPath("sub"));
        this.loader.loadSystemProperties();
        File home = new File(DefaultPropertiesLoaderTest.asTempPath("test"));
        Assert.assertFalse((String)"Absolute subdirs are idependent of fcrepo.home.", (boolean)DefaultPropertiesLoaderTest.containsPath(System.getProperty(PROP_TEST), home.getAbsolutePath()));
        DefaultPropertiesLoaderTest.clearProps();
    }

    @Test
    public void relativePathsWorkForFedoraHome() {
        System.setProperty(HOME_PROP, "test");
        System.setProperty(PROP_TEST, "sub");
        this.loader.loadSystemProperties();
        Assert.assertEquals((Object)new File(new File("test"), "sub"), (Object)new File(System.getProperty(PROP_TEST)));
        DefaultPropertiesLoaderTest.clearProps();
    }

    private static boolean containsPath(String path, String parentPath) {
        File parent = new File(parentPath);
        File f = new File(path);
        while (f.getParentFile() != null) {
            if (f.getParentFile().equals(parent)) {
                return true;
            }
            f = f.getParentFile();
        }
        return false;
    }

    private static String asTempPath(String file) {
        return System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + file;
    }
}

