/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.spring;

import java.io.IOException;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.impl.spring.ModeShapeRepositoryFactoryBean;
import org.fcrepo.kernel.utils.TestHelpers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrRepositoryFactory;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.api.Repository;
import org.springframework.core.io.Resource;

public class ModeShapeRepositoryFactoryBeanTest {
    private ModeShapeRepositoryFactoryBean testObj;
    @Mock
    private Resource mockConfig;
    @Mock
    private JcrRepository mockRepo;
    @Mock
    private JcrRepositoryFactory mockRepos;
    @Mock
    private JcrSession mockSession;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockRepo.login()).thenReturn((Object)this.mockSession);
        this.testObj = new ModeShapeRepositoryFactoryBean();
        this.testObj.setRepositoryConfiguration(this.mockConfig);
        Mockito.when((Object)this.mockRepos.getRepository((Map)Matchers.any(Map.class))).thenReturn((Object)this.mockRepo);
        TestHelpers.setField(this.testObj, "jcrRepositoryFactory", this.mockRepos);
    }

    @Test
    public void testFactory() throws RepositoryException, IOException {
        this.testObj.buildRepository();
        Assert.assertEquals((Object)this.mockRepo, (Object)this.testObj.getObject());
    }

    @Test
    public void testFactoryMetadata() {
        Assert.assertEquals(Repository.class, (Object)this.testObj.getObjectType());
        Assert.assertEquals((Object)true, (Object)this.testObj.isSingleton());
    }
}

