/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils;

import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.impl.utils.BinaryCacheEntry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class BinaryCacheEntryTest {
    @Mock
    private Property mockProperty;
    @Mock
    private Binary mockBinary;
    @Mock
    private InputStream mockInputStream;
    private BinaryCacheEntry testObj;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockProperty.getBinary()).thenReturn((Object)this.mockBinary);
        Mockito.when((Object)this.mockProperty.getPath()).thenReturn((Object)"/some/path");
        this.testObj = new BinaryCacheEntry(this.mockProperty);
    }

    @Test
    public void testGetInputStream() throws Exception {
        Mockito.when((Object)this.mockBinary.getStream()).thenReturn((Object)this.mockInputStream);
        InputStream actual = this.testObj.getInputStream();
        Assert.assertEquals((Object)this.mockInputStream, (Object)actual);
        ((Binary)Mockito.verify((Object)this.mockBinary)).getStream();
    }

    @Test
    public void testGetExternalIdentifier() throws Exception {
        Assert.assertEquals((Object)"/some/path", (Object)this.testObj.getExternalIdentifier());
    }
}

