/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils;

import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.impl.utils.NamespaceChangedStatementListener;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class NamespaceChangedStatementListenerTest {
    private NamespaceChangedStatementListener testObj;
    @Mock
    private NamespaceRegistry mockNamespaceRegistry;
    @Mock
    private Session mockSession;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private Statement mockStatement;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNamespaceRegistry);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        this.testObj = new NamespaceChangedStatementListener(this.mockSession);
    }

    @Test
    public void shouldAddNamespaceStatement() throws RepositoryException {
        Mockito.when((Object)this.mockStatement.getSubject()).thenReturn((Object)ResourceFactory.createResource((String)"uri"));
        Mockito.when((Object)this.mockStatement.getPredicate()).thenReturn((Object)RdfLexicon.HAS_NAMESPACE_PREFIX);
        Mockito.when((Object)this.mockStatement.getObject()).thenReturn((Object)ResourceFactory.createPlainLiteral((String)"123"));
        this.testObj.addedStatement(this.mockStatement);
        ((NamespaceRegistry)Mockito.verify((Object)this.mockNamespaceRegistry)).registerNamespace("123", "uri");
    }

    @Test
    public void shouldIgnoreNonNamespaceStatements() throws RepositoryException {
        Mockito.when((Object)this.mockStatement.getSubject()).thenReturn((Object)ResourceFactory.createResource((String)"uri"));
        Mockito.when((Object)this.mockStatement.getPredicate()).thenReturn((Object)ResourceFactory.createProperty((String)"some-random-predicate"));
        Mockito.when((Object)this.mockStatement.getObject()).thenReturn((Object)ResourceFactory.createPlainLiteral((String)"abc"));
        this.testObj.addedStatement(this.mockStatement);
        ((NamespaceRegistry)Mockito.verify((Object)this.mockNamespaceRegistry, (VerificationMode)Mockito.never())).registerNamespace("abc", "uri");
    }

    @Test
    public void shouldRemoveNamespaceStatement() throws RepositoryException {
        Mockito.when((Object)this.mockStatement.getSubject()).thenReturn((Object)ResourceFactory.createResource((String)"uri"));
        Mockito.when((Object)this.mockStatement.getPredicate()).thenReturn((Object)RdfLexicon.HAS_NAMESPACE_PREFIX);
        Mockito.when((Object)this.mockStatement.getObject()).thenReturn((Object)ResourceFactory.createPlainLiteral((String)"123"));
        Mockito.when((Object)this.mockNamespaceRegistry.getPrefix("uri")).thenReturn((Object)"123");
        this.testObj.removedStatement(this.mockStatement);
        ((NamespaceRegistry)Mockito.verify((Object)this.mockNamespaceRegistry)).unregisterNamespace("123");
    }

    @Test
    public void shouldIgnoreNonMatchingNamespacesOnRemoveNamespaceStatement() throws RepositoryException {
        Mockito.when((Object)this.mockStatement.getSubject()).thenReturn((Object)ResourceFactory.createResource((String)"uri"));
        Mockito.when((Object)this.mockStatement.getPredicate()).thenReturn((Object)RdfLexicon.HAS_NAMESPACE_PREFIX);
        Mockito.when((Object)this.mockStatement.getObject()).thenReturn((Object)ResourceFactory.createPlainLiteral((String)"456"));
        Mockito.when((Object)this.mockNamespaceRegistry.getPrefix("uri")).thenReturn((Object)"123");
        this.testObj.removedStatement(this.mockStatement);
        ((NamespaceRegistry)Mockito.verify((Object)this.mockNamespaceRegistry, (VerificationMode)Mockito.never())).unregisterNamespace("456");
    }

    @Test
    public void shouldIgnoreNonNamespaceStatementsOnRemove() throws RepositoryException {
        Mockito.when((Object)this.mockStatement.getSubject()).thenReturn((Object)ResourceFactory.createResource((String)"uri"));
        Mockito.when((Object)this.mockStatement.getPredicate()).thenReturn((Object)ResourceFactory.createProperty((String)"some-random-predicate"));
        Mockito.when((Object)this.mockStatement.getObject()).thenReturn((Object)ResourceFactory.createPlainLiteral((String)"abc"));
        this.testObj.removedStatement(this.mockStatement);
        ((NamespaceRegistry)Mockito.verify((Object)this.mockNamespaceRegistry, (VerificationMode)Mockito.never())).unregisterNamespace("abc");
    }
}

