/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils.infinispan;

import java.io.IOException;
import org.fcrepo.kernel.impl.utils.infinispan.StoreChunkInputStream;
import org.fcrepo.kernel.utils.TestHelpers;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class StoreChunkInputStreamTest {
    private static final int DATA_SIZE = 1024;
    private StoreChunkInputStream testObj;
    @Mock
    private CacheStore mockStore;
    @Mock
    private InternalCacheEntry mockEntry;
    private static final String MOCK_KEY = "key-to-a-mock-blob";
    private static final String MOCK_FIRST_CHUNK = "key-to-a-mock-blob-0";

    @Before
    public void setUp() throws CacheLoaderException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockStore.containsKey((Object)MOCK_FIRST_CHUNK)).thenReturn((Object)true);
        this.testObj = new StoreChunkInputStream(this.mockStore, MOCK_KEY);
    }

    @Test
    public void testRead() throws IOException {
        this.testObj.read();
    }

    @Test
    public void testBufferedRead() throws IOException, CacheLoaderException {
        byte[] data = TestHelpers.randomData(1024);
        Mockito.when((Object)this.mockEntry.getValue()).thenReturn((Object)data);
        Mockito.when((Object)this.mockStore.load((Object)Matchers.anyString())).thenReturn((Object)this.mockEntry).thenReturn((Object)this.mockEntry).thenReturn(null);
        int partition = 234;
        int expected = 790;
        byte[] buffer = new byte[1024];
        long actual = this.testObj.read(buffer, 0, 790);
        Assert.assertEquals((long)790L, (long)actual);
        actual = this.testObj.read(buffer, 0, 1024);
        Assert.assertEquals((long)234L, (long)actual);
        actual = this.testObj.read(buffer, 0, 1024);
        Assert.assertEquals((long)1024L, (long)actual);
        actual = this.testObj.read(buffer, 0, 1024);
        Assert.assertEquals((long)-1L, (long)actual);
    }

    @Test
    public void testAvailable() throws IOException, CacheLoaderException {
        byte[] data = TestHelpers.randomData(1024);
        Mockito.when((Object)this.mockEntry.getValue()).thenReturn((Object)data);
        Mockito.when((Object)this.mockStore.load((Object)MOCK_FIRST_CHUNK)).thenReturn((Object)this.mockEntry);
        Assert.assertEquals((long)0L, (long)this.testObj.available());
        int partition = 435;
        this.testObj.skip(435L);
        Assert.assertEquals((long)589L, (long)this.testObj.available());
        this.testObj.skip(589L);
        Assert.assertEquals((long)0L, (long)this.testObj.available());
        this.testObj.skip(1L);
        Assert.assertEquals((long)-1L, (long)this.testObj.available());
    }

    @Test
    public void testSkip() throws IOException, CacheLoaderException {
        long expected = 1023L;
        byte[] data = TestHelpers.randomData(1024);
        Mockito.when((Object)this.mockEntry.getValue()).thenReturn((Object)data);
        Mockito.when((Object)this.mockStore.load((Object)MOCK_FIRST_CHUNK)).thenReturn((Object)this.mockEntry);
        long actual = this.testObj.skip(1023L);
        Assert.assertEquals((long)1023L, (long)actual);
        ((CacheStore)Mockito.verify((Object)this.mockStore)).load((Object)Matchers.anyString());
        ((CacheStore)Mockito.verify((Object)this.mockStore)).load((Object)MOCK_FIRST_CHUNK);
        ((InternalCacheEntry)Mockito.verify((Object)this.mockEntry)).getValue();
        Assert.assertTrue((this.testObj.read() > -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)-1L, (long)this.testObj.read());
    }

    @Test
    public void testSkipMultipleBuffers() throws IOException, CacheLoaderException {
        byte[] data = TestHelpers.randomData(1024);
        Mockito.when((Object)this.mockEntry.getValue()).thenReturn((Object)data);
        Mockito.when((Object)this.mockStore.load((Object)Matchers.anyString())).thenReturn((Object)this.mockEntry).thenReturn((Object)this.mockEntry).thenReturn(null);
        long expected = 1024L;
        long actual = this.testObj.skip(1025L);
        Assert.assertEquals((long)expected, (long)actual);
        expected = 1023L;
        actual = this.testObj.skip(expected);
        Assert.assertEquals((long)expected, (long)actual);
        Assert.assertTrue((this.testObj.read() > -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)-1L, (long)this.testObj.read());
        ((InternalCacheEntry)Mockito.verify((Object)this.mockEntry, (VerificationMode)Mockito.times((int)2))).getValue();
    }

    @Test
    public void testNextChunk() throws IOException {
        this.testObj.nextChunk();
    }
}

