/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils.infinispan;

import java.io.IOException;
import org.fcrepo.kernel.impl.utils.infinispan.StoreChunkOutputStream;
import org.fcrepo.kernel.utils.TestHelpers;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class StoreChunkOutputStreamTest {
    private static final int DATA_SIZE = 1024;
    private StoreChunkOutputStream testObj;
    @Mock
    private CacheStore mockStore;
    @Mock
    private InternalCacheEntry mockEntry;
    private static final String MOCK_KEY = "key-to-a-mock-blob";

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new StoreChunkOutputStream(this.mockStore, MOCK_KEY);
    }

    @Test
    public void testWritingMultipleChunks() throws IOException, CacheLoaderException {
        byte[] data = TestHelpers.randomData(1024);
        for (int i = 0; i < 1025; ++i) {
            this.testObj.write(data);
        }
        this.testObj.close();
        ((CacheStore)Mockito.verify((Object)this.mockStore, (VerificationMode)Mockito.times((int)2))).store((InternalCacheEntry)Matchers.any(InternalCacheEntry.class));
        Assert.assertEquals((long)2L, (long)this.testObj.getNumberChunks());
    }

    @Test
    public void testWritingMultipleChunksOnVersionedKey() throws IOException, CacheLoaderException {
        byte[] data = TestHelpers.randomData(1024);
        Mockito.when((Object)this.mockStore.load((Object)"key-to-a-mock-blob-0")).thenReturn((Object)this.mockEntry);
        for (int i = 0; i < 1025; ++i) {
            this.testObj.write(data);
        }
        this.testObj.close();
        ((CacheStore)Mockito.verify((Object)this.mockStore)).load((Object)"key-to-a-mock-blob-0");
        ((CacheStore)Mockito.verify((Object)this.mockStore, (VerificationMode)Mockito.times((int)2))).store((InternalCacheEntry)Matchers.any(InternalCacheEntry.class));
        Assert.assertEquals((long)2L, (long)this.testObj.getNumberChunks());
    }
}

