/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils.iterators;

import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.impl.utils.iterators.PersistingRdfStreamConsumer;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class PersistingRdfStreamConsumerTest {
    private static final Model m = ModelFactory.createDefaultModel();
    private static final Node subject = m.createResource("x").asNode();
    private static final Node object = m.createResource("y").asNode();
    private static final Node foreignSubject = m.createResource("z").asNode();
    private static final Triple propertyTriple = Triple.create((Node)subject, (Node)NodeFactory.createAnon(), (Node)object);
    private static final Statement propertyStatement = m.asStatement(propertyTriple);
    private static final Triple ldpManagedPropertyTriple = Triple.create((Node)subject, (Node)RdfLexicon.PAGE.asNode(), (Node)object);
    private static final Statement ldpManagedPropertyStatement = m.asStatement(ldpManagedPropertyTriple);
    private static final Triple fedoraManagedPropertyTriple = Triple.create((Node)subject, (Node)NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#thing"), (Node)object);
    private static final Statement fedoraManagedPropertyStatement = m.asStatement(fedoraManagedPropertyTriple);
    private static final Statement jcrManagedPropertyStatement = ResourceFactory.createStatement((Resource)ResourceFactory.createResource(), (Property)ResourceFactory.createProperty((String)"http://www.jcp.org/jcr/1.0", (String)"thing"), (RDFNode)ResourceFactory.createResource());
    private static final Triple managedMixinTriple = Triple.create((Node)subject, (Node)RDF.type.asNode(), (Node)NodeFactory.createURI((String)"http://fedora.info/definitions/v4/rest-api#mixin"));
    private static final Statement managedMixinStatement = m.asStatement(managedMixinTriple);
    private static final Triple mixinTriple = Triple.create((Node)subject, (Node)RDF.type.asNode(), (Node)NodeFactory.createURI((String)"myNS:mymixin"));
    private static final Statement mixinStatement = m.asStatement(mixinTriple);
    private static final Triple foreignTriple = Triple.create((Node)foreignSubject, (Node)NodeFactory.createAnon(), (Node)object);
    private static final Statement foreignStatement = m.asStatement(foreignTriple);
    private static final Statement[] fedoraStatements = new Statement[]{propertyStatement, ldpManagedPropertyStatement, mixinStatement, managedMixinStatement, jcrManagedPropertyStatement, fedoraManagedPropertyStatement};
    private static final Statement[] profferedStatements = (Statement[])ObjectArrays.concat((Object[])fedoraStatements, (Object)foreignStatement);
    private static final Resource[] profferedMixins = new Resource[]{mixinStatement.getObject().asResource(), managedMixinStatement.getObject().asResource()};
    @Mock
    private Session mockSession;
    @Mock
    private javax.jcr.Node mockNode;
    @Mock
    private IdentifierTranslator mockGraphSubjects;
    @Mock
    private Iterator<Triple> mockTriples;
    private PersistingRdfStreamConsumer testPersister;

    @Test
    public void testConsumeAsync() throws Exception {
        RdfStream testStream = new RdfStream(profferedStatements);
        final HashSet rejectedStatements = Sets.newHashSet((Object[])profferedStatements);
        final HashSet acceptedStatements = Sets.newHashSet();
        final HashSet rejectedMixins = Sets.newHashSet((Object[])profferedMixins);
        final HashSet acceptedMixins = Sets.newHashSet();
        this.testPersister = new PersistingRdfStreamConsumer(this.mockGraphSubjects, this.mockSession, testStream){

            protected void operateOnProperty(Statement s, javax.jcr.Node subjectNode) throws RepositoryException {
                rejectedStatements.remove(s);
                acceptedStatements.add(s);
            }

            protected void operateOnMixin(Resource mixinResource, javax.jcr.Node subjectNode) throws RepositoryException {
                rejectedMixins.remove(mixinResource);
                acceptedMixins.add(mixinResource);
            }
        };
        this.testPersister.consumeAsync();
        Assert.assertTrue((String)"Failed to operate on ordinary property!", (acceptedStatements.contains(propertyStatement) && !rejectedStatements.contains(propertyStatement) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Wrongly operated on LDP managed property!", (!acceptedStatements.contains(ldpManagedPropertyStatement) && rejectedStatements.contains(ldpManagedPropertyStatement) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Wrongly operated on JCR managed property!", (!acceptedStatements.contains(jcrManagedPropertyStatement) && rejectedStatements.contains(jcrManagedPropertyStatement) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Wrongly operated on Fedora managed property!", (!acceptedStatements.contains(fedoraManagedPropertyStatement) && rejectedStatements.contains(fedoraManagedPropertyStatement) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Wrongly operated on foreign property!", (!acceptedStatements.contains(foreignStatement) && rejectedStatements.contains(foreignStatement) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Wrongly operated on managed mixin!", (!acceptedMixins.contains(managedMixinStatement.getObject().asResource()) && rejectedMixins.contains(managedMixinStatement.getObject().asResource()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Failed to operate on ordinary mixin!", (acceptedMixins.contains(mixinStatement.getObject().asResource()) && !rejectedMixins.contains(mixinStatement.getObject().asResource()) ? 1 : 0) != 0);
    }

    @Test(expected=ExecutionException.class)
    public void testBadStream() throws Exception {
        Mockito.when((Object)this.mockTriples.hasNext()).thenThrow(new Throwable[]{new RuntimeException("Expected.")});
        this.testPersister = new PersistingRdfStreamConsumer(this.mockGraphSubjects, this.mockSession, new RdfStream(this.mockTriples)){

            protected void operateOnProperty(Statement s, javax.jcr.Node subjectNode) throws RepositoryException {
            }

            protected void operateOnMixin(Resource mixinResource, javax.jcr.Node subjectNode) throws RepositoryException {
            }
        };
        this.testPersister.consumeAsync().get();
    }

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        for (Statement fedoraStatement : fedoraStatements) {
            Mockito.when((Object)this.mockSession.getNode(this.mockGraphSubjects.getPathFromSubject(fedoraStatement.getSubject()))).thenReturn((Object)this.mockNode);
            Mockito.when((Object)this.mockGraphSubjects.isFedoraGraphSubject(fedoraStatement.getSubject())).thenReturn((Object)true);
        }
        Mockito.when((Object)this.mockSession.getNode(this.mockGraphSubjects.getPathFromSubject(foreignStatement.getSubject()))).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockGraphSubjects.isFedoraGraphSubject(foreignStatement.getSubject())).thenReturn((Object)false);
    }
}

