/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.impl.rdf.impl.FixityRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.HierarchyRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.NamespaceRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.PropertiesRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.ReferencesRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.VersionsRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.WorkspaceRdfContext;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.impl.utils.NodePropertiesTools;
import org.fcrepo.kernel.rdf.HierarchyRdfContextOptions;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.utils.FixityResult;
import org.fcrepo.kernel.utils.NamespaceTools;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.modeshape.jcr.api.NamespaceRegistry;
import org.modeshape.jcr.api.Namespaced;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrRdfTools {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrRdfTools.class);
    public static BiMap<String, String> jcrNamespacesToRDFNamespaces = ImmutableBiMap.of((Object)"http://www.jcp.org/jcr/1.0", (Object)"http://fedora.info/definitions/v4/repository#");
    public static BiMap<String, String> rdfNamespacesToJcrNamespaces = jcrNamespacesToRDFNamespaces.inverse();
    private final IdentifierTranslator graphSubjects;
    private Session session;
    static Predicate<NodeType> HAS_CHILD_NODE_DEFINITIONS = new Predicate<NodeType>(){

        public boolean apply(NodeType input) {
            return input.getChildNodeDefinitions().length > 0;
        }
    };
    public static Function<Property, com.hp.hpl.jena.rdf.model.Property> getPredicateForProperty = new Function<Property, com.hp.hpl.jena.rdf.model.Property>(){

        public com.hp.hpl.jena.rdf.model.Property apply(Property property) {
            LOGGER.trace("Creating predicate for property: {}", (Object)property);
            try {
                if (property instanceof Namespaced) {
                    Namespaced nsProperty = (Namespaced)property;
                    String uri = nsProperty.getNamespaceURI();
                    String localName = nsProperty.getLocalName();
                    String rdfLocalName = FedoraTypesUtils.isReferenceProperty.apply((Object)property) ? NodePropertiesTools.getReferencePropertyOriginalName(localName) : localName;
                    return ResourceFactory.createProperty((String)JcrRdfTools.getRDFNamespaceForJcrNamespace(uri), (String)rdfLocalName);
                }
                return ResourceFactory.createProperty((String)property.getName());
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };

    public JcrRdfTools(IdentifierTranslator graphSubjects) {
        this(graphSubjects, null);
    }

    public JcrRdfTools(IdentifierTranslator graphSubjects, Session session) {
        this.graphSubjects = graphSubjects;
        this.session = session;
    }

    public static JcrRdfTools withContext(IdentifierTranslator graphSubjects) {
        return new JcrRdfTools(graphSubjects);
    }

    public static JcrRdfTools withContext(IdentifierTranslator idTranslator, Session session) {
        Preconditions.checkNotNull((Object)idTranslator, (Object)"JcrRdfTools must operate with a non-null IdentifierTranslator for context!");
        return new JcrRdfTools(idTranslator, session);
    }

    public static String getJcrNamespaceForRDFNamespace(String rdfNamespaceUri) {
        if (rdfNamespacesToJcrNamespaces.containsKey((Object)rdfNamespaceUri)) {
            return (String)rdfNamespacesToJcrNamespaces.get((Object)rdfNamespaceUri);
        }
        return rdfNamespaceUri;
    }

    public static String getRDFNamespaceForJcrNamespace(String jcrNamespaceUri) {
        if (jcrNamespacesToRDFNamespaces.containsKey((Object)jcrNamespaceUri)) {
            return (String)jcrNamespacesToRDFNamespaces.get((Object)jcrNamespaceUri);
        }
        return jcrNamespaceUri;
    }

    public static Model getProblemsModel() {
        return ModelFactory.createDefaultModel();
    }

    public JcrRdfTools withSession(Session session) {
        return new JcrRdfTools(this.graphSubjects, session);
    }

    public RdfStream getJcrPropertiesModel(Iterator<javax.jcr.Node> nodeIterator, Resource iteratorSubject) throws RepositoryException {
        RdfStream results = new RdfStream();
        while (nodeIterator.hasNext()) {
            javax.jcr.Node node = nodeIterator.next();
            results.concat((Iterator)((Object)new PropertiesRdfContext(node, this.graphSubjects)));
            if (iteratorSubject == null) continue;
            results.concat(Collections.singleton(Triple.create((Node)iteratorSubject.asNode(), (Node)RdfLexicon.HAS_MEMBER_OF_RESULT.asNode(), (Node)this.graphSubjects.getSubject(node.getPath()).asNode())));
        }
        return results;
    }

    public RdfStream getJcrTriples(javax.jcr.Node node) throws RepositoryException {
        return new PropertiesRdfContext(node, this.graphSubjects);
    }

    public RdfStream getVersionTriples(javax.jcr.Node node) throws RepositoryException {
        return new VersionsRdfContext(node, this.graphSubjects);
    }

    public RdfStream getJcrTriples(javax.jcr.Node node, Iterable<FixityResult> blobs) throws RepositoryException {
        return new FixityRdfContext(node, this.graphSubjects, blobs);
    }

    public RdfStream getNamespaceTriples() throws RepositoryException {
        return new NamespaceRdfContext(this.session);
    }

    public RdfStream getWorkspaceTriples(IdentifierTranslator subjects) throws RepositoryException {
        return new WorkspaceRdfContext(this.session, subjects);
    }

    public RdfStream getTreeTriples(javax.jcr.Node node, HierarchyRdfContextOptions options) throws RepositoryException {
        return new HierarchyRdfContext(node, this.graphSubjects, options);
    }

    public RdfStream getTreeTriples(javax.jcr.Node node) throws RepositoryException {
        return this.getTreeTriples(node, HierarchyRdfContextOptions.DEFAULT);
    }

    public RdfStream getReferencesTriples(javax.jcr.Node node) throws RepositoryException {
        return new ReferencesRdfContext(node, this.graphSubjects);
    }

    public static boolean isContainer(javax.jcr.Node node) throws RepositoryException {
        return HAS_CHILD_NODE_DEFINITIONS.apply((Object)node.getPrimaryNodeType()) || Iterables.any((Iterable)ImmutableList.copyOf((Object[])node.getMixinNodeTypes()), HAS_CHILD_NODE_DEFINITIONS);
    }

    public boolean isInternalProperty(javax.jcr.Node subjectNode, Resource predicate) {
        switch (predicate.getNameSpace()) {
            case "http://fedora.info/definitions/v4/repository#": 
            case "http://www.jcp.org/jcr/1.0": 
            case "http://www.w3.org/ns/ldp#": {
                return true;
            }
        }
        return false;
    }

    public Value createValue(javax.jcr.Node node, RDFNode data, int type) throws RepositoryException {
        ValueFactory valueFactory = node.getSession().getValueFactory();
        return this.createValue(valueFactory, data, type);
    }

    public Value createValue(RDFNode data) throws RepositoryException {
        return this.createValue(data, 0);
    }

    public Value createValue(RDFNode data, int type) throws RepositoryException {
        return this.createValue(this.session.getValueFactory(), data, type);
    }

    public Value createValue(ValueFactory valueFactory, RDFNode data, int type) throws RepositoryException {
        assert (valueFactory != null);
        if (data.isURIResource() && (type == 9 || type == 10)) {
            javax.jcr.Node nodeFromGraphSubject = this.session.getNode(this.graphSubjects.getPathFromSubject(data.asResource()));
            return valueFactory.createValue(nodeFromGraphSubject, type == 10);
        }
        if (!(data.isURIResource() || type != 9 && type != 10)) {
            throw new ValueFormatException("Reference properties can only refer to URIs, not literals");
        }
        if (data.isURIResource() || type == 11) {
            return valueFactory.createValue(data.toString(), 11);
        }
        if (data.isResource()) {
            return valueFactory.createValue(data.toString(), 0);
        }
        if (data.isLiteral() && type == 0) {
            Literal literal = data.asLiteral();
            RDFDatatype dataType = literal.getDatatype();
            Object rdfValue = literal.getValue();
            if (rdfValue instanceof Boolean) {
                return valueFactory.createValue(((Boolean)rdfValue).booleanValue());
            }
            if (rdfValue instanceof Byte || dataType != null && dataType.getJavaClass() == Byte.class) {
                return valueFactory.createValue((long)literal.getByte());
            }
            if (rdfValue instanceof Double) {
                return valueFactory.createValue(((Double)rdfValue).doubleValue());
            }
            if (rdfValue instanceof Float) {
                return valueFactory.createValue((double)((Float)rdfValue).floatValue());
            }
            if (rdfValue instanceof Long || dataType != null && dataType.getJavaClass() == Long.class) {
                return valueFactory.createValue(literal.getLong());
            }
            if (rdfValue instanceof Short || dataType != null && dataType.getJavaClass() == Short.class) {
                return valueFactory.createValue((long)literal.getShort());
            }
            if (rdfValue instanceof Integer) {
                return valueFactory.createValue((long)((Integer)rdfValue).intValue());
            }
            if (rdfValue instanceof XSDDateTime) {
                return valueFactory.createValue(((XSDDateTime)rdfValue).asCalendar());
            }
            return valueFactory.createValue(literal.getString(), 1);
        }
        LOGGER.debug("Using default JCR value creation for RDF literal: {}", (Object)data);
        return valueFactory.createValue(data.asLiteral().getString(), type);
    }

    public String getPropertyNameFromPredicate(javax.jcr.Node node, com.hp.hpl.jena.rdf.model.Property predicate) throws RepositoryException {
        Map<String, String> s = Collections.emptyMap();
        return this.getPropertyNameFromPredicate(node, predicate, s);
    }

    public String getPropertyNameFromPredicate(javax.jcr.Node node, com.hp.hpl.jena.rdf.model.Property predicate, Map<String, String> namespaceMapping) throws RepositoryException {
        NamespaceRegistry namespaceRegistry = (NamespaceRegistry)NamespaceTools.getNamespaceRegistry.apply((Object)node);
        return this.getJcrNameForRdfNode(namespaceRegistry, predicate.getNameSpace(), predicate.getLocalName(), namespaceMapping);
    }

    public String getPropertyNameFromPredicate(com.hp.hpl.jena.rdf.model.Property predicate) throws RepositoryException {
        NamespaceRegistry namespaceRegistry = (NamespaceRegistry)this.session.getWorkspace().getNamespaceRegistry();
        Map<String, String> namespaceMapping = Collections.emptyMap();
        return this.getJcrNameForRdfNode(namespaceRegistry, predicate.getNameSpace(), predicate.getLocalName(), namespaceMapping);
    }

    public String getPropertyNameFromPredicate(javax.jcr.Node node, Resource resource, Map<String, String> namespaces) throws RepositoryException {
        NamespaceRegistry namespaceRegistry = (NamespaceRegistry)NamespaceTools.getNamespaceRegistry.apply((Object)node);
        return this.getJcrNameForRdfNode(namespaceRegistry, resource.getNameSpace(), resource.getLocalName(), namespaces);
    }

    private String getJcrNameForRdfNode(NamespaceRegistry namespaceRegistry, String rdfNamespace, String rdfLocalname, Map<String, String> namespaceMapping) throws RepositoryException {
        String prefix;
        String namespace = JcrRdfTools.getJcrNamespaceForRDFNamespace(rdfNamespace);
        assert (namespaceRegistry != null);
        if (namespaceRegistry.isRegisteredUri(namespace)) {
            LOGGER.debug("Discovered namespace: {} in namespace registry.", (Object)namespace);
            prefix = namespaceRegistry.getPrefix(namespace);
        } else {
            LOGGER.debug("Didn't discover namespace: {} in namespace registry.", (Object)namespace);
            ImmutableBiMap nsMap = ImmutableBiMap.copyOf(namespaceMapping);
            if (nsMap.containsValue((Object)namespace)) {
                LOGGER.debug("Discovered namespace: {} in namespace map: {}.", (Object)namespace, (Object)nsMap);
                prefix = (String)nsMap.inverse().get((Object)namespace);
                namespaceRegistry.registerNamespace(prefix, namespace);
            } else {
                prefix = namespaceRegistry.registerNamespace(namespace);
            }
        }
        String propertyName = prefix + ":" + rdfLocalname;
        LOGGER.debug("Took RDF predicate {} and translated it to JCR property {}", (Object)namespace, (Object)propertyName);
        return propertyName;
    }

    public int getPropertyType(String nodeType, String propertyName) throws RepositoryException {
        return this.getPropertyType(this.session.getWorkspace().getNodeTypeManager().getNodeType(nodeType), propertyName);
    }

    public int getPropertyType(NodeType nodeType, String propertyName) {
        PropertyDefinition[] propertyDefinitions = nodeType.getPropertyDefinitions();
        int type = 0;
        for (PropertyDefinition propertyDefinition : propertyDefinitions) {
            if (!propertyDefinition.getName().equals(propertyName)) continue;
            if (type != 0) {
                return 0;
            }
            type = propertyDefinition.getRequiredType();
        }
        return type;
    }
}

