/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.impl.rdf.impl.NodeRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.PropertiesRdfContext;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.rdf.HierarchyRdfContextOptions;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.utils.iterators.NodeIterator;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchyRdfContext
extends NodeRdfContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(HierarchyRdfContext.class);
    private final HierarchyRdfContextOptions options;
    private static Predicate<javax.jcr.Node> nastyChildren = new Predicate<javax.jcr.Node>(){

        public boolean apply(javax.jcr.Node n) {
            LOGGER.trace("Testing child node {}", (Object)n);
            try {
                return FedoraTypesUtils.isInternalNode.apply((Object)n) || n.getName().equals("jcr:content");
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };

    public HierarchyRdfContext(javax.jcr.Node node, IdentifierTranslator graphSubjects, HierarchyRdfContextOptions options) throws RepositoryException {
        super(node, graphSubjects);
        this.options = options;
        if (JcrRdfTools.isContainer(node)) {
            LOGGER.trace("Determined that this node is a container.");
            this.concat(this.containerContext());
        } else {
            LOGGER.trace("Determined that this node is not a container.");
        }
        if (node.getDepth() > 0) {
            LOGGER.trace("Determined that this node has a parent.");
            this.concat(this.parentContext());
        }
        if ((options.membershipEnabled() || options.containmentEnabled()) && node.hasNodes()) {
            LOGGER.trace("Found children of this node.");
            this.concat(this.childrenContext());
        }
    }

    private Triple[] containerContext() {
        return new Triple[]{Triple.create((Node)this.subject(), (Node)RDF.type.asNode(), (Node)RdfLexicon.CONTAINER.asNode()), Triple.create((Node)this.subject(), (Node)RDF.type.asNode(), (Node)RdfLexicon.DIRECT_CONTAINER.asNode()), Triple.create((Node)this.subject(), (Node)RdfLexicon.MEMBERSHIP_RESOURCE.asNode(), (Node)this.subject()), Triple.create((Node)this.subject(), (Node)RdfLexicon.HAS_MEMBER_RELATION.asNode(), (Node)RdfLexicon.HAS_CHILD.asNode())};
    }

    private Iterator<Triple> parentContext() throws RepositoryException {
        javax.jcr.Node parentNode = this.node().getParent();
        Node parentNodeSubject = this.graphSubjects().getSubject(parentNode.getPath()).asNode();
        RdfStream parentStream = new RdfStream();
        parentStream.concat(Triple.create((Node)this.subject(), (Node)RdfLexicon.HAS_PARENT.asNode(), (Node)parentNodeSubject));
        return parentStream;
    }

    private Iterator<Triple> childrenContext() throws RepositoryException {
        UnmodifiableIterator niceChildren = Iterators.filter((Iterator)new NodeIterator(this.node().getNodes()), (Predicate)Predicates.not(nastyChildren));
        if (this.options.hasOffset()) {
            int offset = this.options.getOffset();
            Iterators.advance((Iterator)niceChildren, (int)offset);
        }
        Object salientChildren = this.options.hasLimit() ? Iterators.limit((Iterator)niceChildren, (int)this.options.getLimit()) : niceChildren;
        return Iterators.concat((Iterator)Iterators.transform((Iterator)salientChildren, this.child2triples()));
    }

    private Function<javax.jcr.Node, Iterator<Triple>> child2triples() {
        return new Function<javax.jcr.Node, Iterator<Triple>>(){

            public Iterator<Triple> apply(javax.jcr.Node child) {
                try {
                    Node childSubject = HierarchyRdfContext.this.graphSubjects().getSubject(child.getPath()).asNode();
                    LOGGER.trace("Creating triples for child node: {}", (Object)child);
                    RdfStream childStream = new RdfStream();
                    if (HierarchyRdfContext.this.options.membershipEnabled()) {
                        childStream.concat(Triple.create((Node)HierarchyRdfContext.this.subject(), (Node)RdfLexicon.HAS_CHILD.asNode(), (Node)childSubject));
                    }
                    if (HierarchyRdfContext.this.options.containmentEnabled()) {
                        childStream.concat((Iterator)((Object)new PropertiesRdfContext(child, HierarchyRdfContext.this.graphSubjects())));
                        childStream.concat(new Triple[]{Triple.create((Node)childSubject, (Node)RdfLexicon.HAS_PARENT.asNode(), (Node)HierarchyRdfContext.this.subject()), Triple.create((Node)HierarchyRdfContext.this.subject(), (Node)RdfLexicon.CONTAINS.asNode(), (Node)childSubject)});
                    }
                    return childStream;
                }
                catch (RepositoryException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }
}

